<?php
// Configuração do banco de dados
$host = "162.240.148.136";
$port = "5432";
$dbname = "wwsisp_postgres";
$user = "postgres";
$password = "R312@dm1nj3q";

try {
    // Conectar ao PostgreSQL
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Gerar o número de protocolo (sem o prefixo "SOL-")
    $dataAtual = date("Ymd");
    $numeroAleatorio = mt_rand(10000, 99999);
    $protocolo = $dataAtual . '-' . $numeroAleatorio;  // Remover o "SOL-" e manter o número

    // Receber dados do JSON
    $data = json_decode(file_get_contents("php://input"), true);
    $lat = $data['lat'];
    $lng = $data['lng'];
    $tipoServico = $data['tipoServico'];
    $detalhes = $data['detalhes'];
    $username = $data['username'];
    $userGroupId = $data['userGroupId'];
    $status_solicitacao = $data['status_solicitacao'] ?? 'Em Aberto'; // Default status if not provided

    // Inserir solicitação no banco de dados
    $sql = "INSERT INTO solicitacoes (latitude, longitude, tipo_servico, detalhes, username, userGroupId, status_solicitacao, protocolo) 
            VALUES (:lat, :lng, :tipo_servico, :detalhes, :username, :userGroupId, :status_solicitacao, :protocolo)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':lat' => $lat,
        ':lng' => $lng,
        ':tipo_servico' => $tipoServico,
        ':detalhes' => $detalhes,
        ':username' => $username,
        ':userGroupId' => $userGroupId,
        ':status_solicitacao' => $status_solicitacao,
        ':protocolo' => $protocolo
    ]);

    // Retornar resposta com status e número do protocolo
    echo json_encode([
        "status" => "sucesso",
        "protocolo" => $protocolo // Retornar o número do protocolo sem o "SOL-"
    ]);
} catch (PDOException $e) {
    echo json_encode(["status" => "erro", "mensagem" => $e->getMessage()]);
}
?>
