import { calcularValorMercado } from './calcValor.js';

export function aplicarAvaliacao(layer) {
  const props = layer.feature.properties;

  const area = props.area_construida || 200; // default
  const zona = props.zoneamento || 'ZR-1';

  const valorEstimado = calcularValorMercado(area, zona);

  // Insere no popup
  const popupHTML = `
    <div style="font-family: Arial; width: 250px;">
      <h4 style="text-align:center;">Avaliação Imobiliária</h4>
      <table style="width:100%; font-size:13px;">
        <tr><td><strong>Inscrição:</strong></td><td style="text-align:right;">${props.inscricao}</td></tr>
        <tr><td><strong>Zona:</strong></td><td style="text-align:right;">${zona}</td></tr>
        <tr><td><strong>Área construída:</strong></td><td style="text-align:right;">${area} m²</td></tr>
        <tr><td><strong>Valor estimado:</strong></td><td style="text-align:right;">R$ ${valorEstimado.toLocaleString('pt-BR')}</td></tr>
      </table>
    </div>
  `;

  layer.bindPopup(popupHTML);
}
