<?php
require_once __DIR__ . '/../../init.php'; // Certifique-se de carregar o Adianti Framework
use Adianti\Core\TSession;

header('Content-Type: application/json');

try {
    // Garante que a sessão do Adianti está iniciada
    if (!TSession::getValue('logged')) {
        echo json_encode(['error' => 'Usuário não autenticado']);
        exit;
    }

    $grupos_id = TSession::getValue('usergroupids');

    // Se for null, retorna array vazio
    echo json_encode(['groups' => $grupos_id ?? []]);

} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
