<?php
// Configurar o cabeçalho de resposta como JSON
header('Content-Type: application/json');

ini_set('display_errors', 1);
error_reporting(E_ALL);

try {
    // Obtenha o JSON input
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    if ($data === null) {
        throw new Exception('Invalid JSON input');
    }

    // Carregar o GeoJSON existente
    $geojsonFile = $_SERVER['DOCUMENT_ROOT'] . '/geojequie/geojson_edit/poligononuvem.geojson';
    $geojsonData = json_decode(file_get_contents($geojsonFile), true);

    if ($geojsonData === null) {
        throw new Exception('Failed to load GeoJSON file');
    }

    // Remover as camadas deletadas dos dados GeoJSON
    $remainingFeatures = array_filter($geojsonData['features'], function($feature) use ($data) {
        // Compara as coordenadas para verificar se a feature deve ser removida
        return json_encode($feature['geometry']['coordinates']) !== json_encode($data['geometry']['coordinates']);
    });

    // Reindexar as features após o filtro
    $geojsonData['features'] = array_values($remainingFeatures);

    // Salvar o GeoJSON atualizado
    $result = file_put_contents($geojsonFile, json_encode($geojsonData, JSON_PRETTY_PRINT));

    if ($result === false) {
        throw new Exception('Failed to save GeoJSON file');
    }

    echo json_encode(['success' => true, 'message' => 'Polígono deletado com sucesso']);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
