<?php

header('Content-Type: application/json; charset=UTF-8');

// Verifique se o parâmetro 'inscricao' foi passado na URL
if (isset($_GET['inscricao'])) {
    $inscricao = $_GET['inscricao'];
    if (empty($inscricao)) {
        http_response_code(400);
        echo json_encode(['error' => 'Inscrição está vazia ou nula']);
        exit();
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Inscrição não fornecida']);
    exit();
}

// Obter o tipo de operação da URL (consulta ou cadastro)
$operacao = $_GET['operacao'] ?? 'consulta';

// Função para obter o token
function getToken() {
    $url = 'https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/auth';
    $data = [
        'usuario' => 'PM_BA_JEQUIE',
        'senha' => '8e39d3b8-500a'
    ];

    return apiRequest($url, $data, false)['token'] ?? false;
}

// Função para realizar requisições à API
function apiRequest($url, $data, $useToken = true) {
    $jsonData = json_encode($data, JSON_UNESCAPED_UNICODE);
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);  // Timeout de 10 segundos

    if ($useToken) {
        $token = getToken();
        if (!$token) {
            http_response_code(500);
            echo json_encode(['error' => 'Falha ao obter token de autenticação']);
            exit();
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token
        ]);
    }

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        logMessage("Erro na requisição: " . curl_error($ch));
        curl_close($ch);
        return ['error' => 'Erro na requisição'];
    }

    curl_close($ch);
    
    return json_decode($response, true);
}

// Realizar a operação solicitada
if ($operacao === 'consulta') {
    $url = 'https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/inscricao';
    $data = ['inscricao_municipal' => $inscricao];
} elseif ($operacao === 'cadastro') {
    $url = 'https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/cadastro';
    $data = [
        'inscricao_municipal' => $inscricao,
        'proprietario' => 'Exemplo Proprietário',
        'logradouro' => 'Exemplo Logradouro',
        'bairro' => 'Exemplo Bairro',
    ];
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Operação inválida']);
    exit();
}

// Chamar a API
$responseData = apiRequest($url, $data);

// Retornar resposta da API
echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

// Função para logar erros
function logMessage($message) {
    file_put_contents('error_log.txt', date('Y-m-d H:i:s') . " - $message\n", FILE_APPEND);
}

// Funções adicionais para consultas
class ConsultaAPI {
    public static function consultarPessoa($documento) {
        return apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/pessoa', ['documento' => $documento]);
    }

    public static function consultarLogradouro($logra) {
        return apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/logradouro', ['nome' => $logra]);
    }

    public static function consultarBairro($bairro) {
        return apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/bairro', ['nome' => $bairro]);
    }

    public static function consultarCidade($cidade) {
        return apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/cidade', ['nome' => $cidade]);
    }
}

?>
