<?php
// check_cnae.php

// Database connection settings
$host = '162.240.148.136';
$port = '5432';
$dbname = 'wwsisp_postgres';
$user = 'postgres';
$password = 'R312@dm1nj3q';

try {
    // Create a new PDO instance
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(['error' => 'Database connection failed: ' . $e->getMessage()]);
    http_response_code(500);
    exit();
}

// Get parameters from URL
$cnae = isset($_GET['cnae']) ? $_GET['cnae'] : null;
$zoneamento = isset($_GET['zoneamento']) ? $_GET['zoneamento'] : null;

if (!$cnae || !$zoneamento) {
    echo json_encode(['error' => 'Missing parameters']);
    http_response_code(400);
    exit();
}

try {
    // Prepare and execute the query
    $stmt = $pdo->prepare("
        SELECT descricao, grau_risco 
        FROM zoning_table 
        WHERE cnae = :cnae AND zoneamento = :zoneamento
    ");
    $stmt->execute(['cnae' => $cnae, 'zoneamento' => $zoneamento]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo json_encode([
            'existe' => true,
            'descricao' => $result['descricao'],
            'grau_risco' => $result['grau_risco']
        ]);
    } else {
        echo json_encode(['existe' => false]);
    }
} catch (PDOException $e) {
    echo json_encode(['error' => 'Query failed: ' . $e->getMessage()]);
    http_response_code(500);
    exit();
}
?>
