<?php

header('Content-Type: application/json; charset=UTF-8');
require_once 'ApiModel.php';

$query = isset($_POST['query']) ? trim($_POST['query']) : '';
if (!$query) {
    echo json_encode([]);
    exit;
}

$api = new ApiModel();

// Verifica se a entrada é um CPF, inscrição ou nome e chama a API correspondente
if (preg_match('/^\d+$/', $query)) {
    if (strlen($query) >= 11) {
        $result = $api->consultarPessoa($query); // CPF
    } else {
        $result = $api->consultarInscricao($query); // Inscrição
    }
} else {
    // Consideramos que seja um endereço ou nome
    $logradouro = $api->consultarLogradouro($query);
    $bairro = $api->consultarBairro($query);
    
    $result = array_merge($logradouro ?? [], $bairro ?? []);
}

// Retorna os resultados encontrados
echo json_encode($result);
?>
