(function () {
  // ==========================
  // 🛣️ PESQUISA DE RUAS
  // ==========================

  function openStreetPanel() {
    if (!setActiveTool('#btn-street', "Pesquisa de Ruas")) return;

    document.getElementById("slide-title").textContent = "Pesquisa de Ruas";
    document.getElementById("slide-content").innerHTML = `
      <section class="street-tools">
        <div class="street-tools__inputs" style="margin-bottom: 12px;">
          <select id="searchType" class="input-field" style="margin-bottom:8px; width:100%;">
            <option value="street">Rua / Avenida</option>
            <option value="feature">Cadastro (WFS)</option>
          </select>

          <div style="display:flex; gap:8px;">
            <input id="searchInput" type="text" placeholder="Digite o nome da rua"
                   class="input-field" style="flex:1;">
            <button type="button" onclick="performSearch()" 
                    class="btn-icon" title="Buscar" aria-label="Buscar">
              <i class="fas fa-search"></i>
            </button>
          </div>
        </div>
      </section>
    `;
  }

  function searchStreet() {
    var query = document.getElementById('searchInput').value.trim();
    if (!query) return alert('Digite o nome da rua ou avenida.');

    var url = `https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(query)}&limit=1`;

    fetch(url, { headers: { 'Accept-Language': 'pt-BR' } })
      .then(res => res.json())
      .then(data => {
        if (!data || data.length === 0) {
          return alert('Endereço não encontrado.');
        }

        var lat = parseFloat(data[0].lat);
        var lon = parseFloat(data[0].lon);
        var coords = ol.proj.fromLonLat([lon, lat]);

        // Criar marcador no mesmo markerSource global
        var streetMarker = new ol.Feature(new ol.geom.Point(coords));
        streetMarker.setStyle(new ol.style.Style({
          image: new ol.style.Icon({
            src: 'vendor/geojequie/css/images/marcador.png',
            crossOrigin: 'anonymous',
            scale: 0.1,
            anchor: [0.5, 1]
          })
        }));

        markerSource.clear(); // limpa marcador anterior
        markerSource.addFeature(streetMarker);

        map.getView().animate({ center: coords, zoom: 18 });
      })
      .catch(err => {
        console.error('Erro na busca de rua:', err);
        alert('Erro ao buscar o endereço.');
      });
  }

  function performSearch() {
    var searchType = document.getElementById('searchType').value;
    var query = document.getElementById('searchInput').value.trim();

    if (!query) {
      alert('Digite um termo para buscar.');
      return;
    }

    if (searchType === 'feature') {
      if (typeof searchFeature === "function") {
        searchFeature(); // sua função já existente
      } else {
        alert("Função searchFeature (WFS) não encontrada.");
      }
    } else if (searchType === 'street') {
      searchStreet();
    }
  }

  // 🔗 Expor globalmente
  window.openStreetPanel = openStreetPanel;
  window.searchStreet = searchStreet;
  window.performSearch = performSearch;
})();
