<!DOCTYPE html>
<html lang="pt-br">

<head>
  <meta charset="UTF-8">
  <title>Mapa Fiscal</title>

  <!-- Estilos do OpenLayers e custom -->
  <link rel="stylesheet" href="vendor/marcelonees/plugins/src/OpenLayers/ol.css">
  <link rel="stylesheet" href="vendor/geojequie/Mapa_Jequie_Fiscal/style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>

<body>

  <!-- ✅ Define o grupo do usuário o mais cedo possível -->
  <script>
    // Se o backend usa PHP, preferir essa linha (garante número):
    window.userGroupId = parseInt('<?= (int) $usergroupid ?>', 10);

    // Se o backend injeta handlebars {{usergroupid}}, a de cima já resolve.
    // Mantenho esta como fallback se necessário:
    if (isNaN(window.userGroupId)) {
      window.userGroupId = parseInt('{{usergroupid}}', 10);
    }
  </script>

  <!-- 🗺️ Mapa será carregado aqui -->
  <div id="mapfisco">

    <!-- Barra de busca -->
    <div id="search-bar" class="search-bar">
      <fieldset class="search-bar__group" aria-label="Busca no mapa">
        <select id="searchType" class="search-bar__select" aria-label="Tipo de busca">
          <option value="feature">Nome ou Inscrição</option>
          <option value="street">Rua ou Avenida</option>
        </select>
        <label for="searchInput" class="visually-hidden">Digite o que deseja buscar</label>
        <input type="text" id="searchInput" class="search-bar__input" placeholder="Digite sua busca..."
          aria-label="Campo de busca" />
        <button type="button" onclick="performSearch()" class="btn-icon" title="Buscar">
          <i class="fas fa-search" aria-hidden="true"></i>
        </button>
      </fieldset>
    </div>

    <!-- 🔘 Painel com botões -->
    <div id="tools-panel">
      <button id="btn-vlayers" class="btn-icon" title="Camadas vetoriais" onclick="openVectorLayersPanel()">
  <i class="fas fa-layer-group"></i>
</button>
      <!-- Todos os grupos (não precisa data-roles, ou usa data-roles="1,2,3") -->     
      <button id="btn-marker" class="btn-icon" title="Minha localização" onclick="openMarkerPanel()"><i class="fas fa-crosshairs"></i></button>

      <!-- Só grupo 1 -->
      <button id="btn-medicao" class="btn-icon" title="Medir distância" data-roles="1,2" onclick="openMeasurementPanel()"><i class="fas fa-ruler"></i></button>

      <!-- Grupo 1 e 2 -->
      <button id="btn-export" class="btn-icon" title="Exportar imagem" data-roles="1,2" onclick="openExportPanel()"><i class="fas fa-camera"></i></button>

      <!-- Todos os grupos (não precisa data-roles, ou usa data-roles="1,2,3") -->
      <button title="Street View" onclick="btnStreetView()"><i class="fas fa-street-view"></i></button>

      <!-- Exemplo só grupo 2 -->
      <button title="Imprimir Mapa" data-roles="1,2" onclick="printMap()"><i class="fas fa-print"></i></button>

    </div>

    <!-- Painel inferior -->
    <div id="bottom-panel" style="position: absolute; bottom: 0; left: 0; width: 100%; 
        height: 30px; background: rgba(255,255,255,0.9); border-top: 1px solid #ccc; 
        display: flex; justify-content: space-between; align-items: center; 
        padding: 0 10px; font-size: 13px; font-family: Arial, sans-serif; z-index: 1000;">
      <div>Lon: 0.00000, Lat: 0.00000</div>
    </div>

    <!-- Slide Panel -->
    <div id="slide-panel" class="slide-panel" style="display: none;">
      <div id="slide-header" class="slide-header">
        <span id="slide-title">Ferramenta</span>
        <button onclick="closeSlidePanel()" class="btn-close">x</button>
      </div>
      <div id="slide-content" class="slide-content"></div>
    </div>

  </div>

  <!-- 📦 Scripts de mapa -->
  <script src="vendor/marcelonees/plugins/src/OpenLayers/ol.js"></script>
  <script src="vendor/geojequie/Mapa_Jequie_Fiscal/mapa_fiscal_jequie_a.js"></script>

  <!-- 🚦 Controle de visibilidade por grupo -->
  <script>
    (function () {
      const group = window.userGroupId;

      function applyRoleControl(root = document) {
        const roleButtons = root.querySelectorAll('[data-roles]');
        roleButtons.forEach(el => {
          const allowed = (el.getAttribute('data-roles') || '')
            .split(',')
            .map(s => parseInt(s.trim(), 10))
            .filter(n => !isNaN(n));
          if (allowed.length && !allowed.includes(group)) {
            el.remove(); // Remove o botão
          }
        });
      }

      // Executa no carregamento
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', () => applyRoleControl(document));
      } else {
        applyRoleControl(document);
      }

      // Observa injeções (Ajax/Adianti)
      const mo = new MutationObserver(mutations => {
        for (const m of mutations) {
          m.addedNodes.forEach(node => {
            if (node.nodeType === 1) {
              applyRoleControl(node);
            }
          });
        }
      });
      mo.observe(document.documentElement, { childList: true, subtree: true });
    })();
  </script>

  <!-- 🛠️ Função utilitária de controle de botões -->
<script>
  function setActiveTool(buttonId, panelTitle) {
  const panel = document.getElementById("slide-panel");
  const title = document.getElementById("slide-title");
  const btn = document.querySelector(buttonId);

  // Se já está aberto com esse painel → fecha
  if (panel.style.display === "block" && title.textContent === panelTitle) {
    panel.style.display = "none";
    btn?.classList.remove("active");
    return false;
  }

  // Desativa todos os botões ativos
  document.querySelectorAll("#tools-panel button.active").forEach(el => el.classList.remove("active"));

  // Ativa o botão atual
  btn?.classList.add("active");
  panel.style.display = "block";
  return true;
}
</script>

  <!-- Ferramenta de medição -->
  <script src="vendor/geojequie/Mapa_Jequie_Fiscal/medida_fiscal.js"></script>
  <!-- Ferramenta de exportar -->
  <script src="vendor/geojequie/Mapa_Jequie_Fiscal/export_fiscal.js"></script>

</body>

</html>