(function () {
    // ==========================
    // 🖼️ EXPORTAR IMAGEM (com marcadores)
    // ==========================

    function openExportPanel() {
        if (!setActiveTool('#btn-export', "Exportar Imagem")) return;

        document.getElementById("slide-title").textContent = "Exportar Imagem";
        document.getElementById("slide-content").innerHTML =  `
                <section class="measurement-tools">
      <div class="measurement-tools__buttons tool-group">
                    <button type="button" onclick="exportImage()" 
                            title="Exportar imagem do mapa" 
                            class="btn-icon" aria-label="Exportar imagem">
                    <i class="fas fa-download"></i>
                    </button>
                </div>

                <div id="loading" style="display:none; margin-top:10px; color:#1976d2; text-align:center;">
                    ⏳ Gerando imagem...
                </div>

                <div id="exportFeedback" style="display:none; margin-top:10px; color:green; text-align:center;">
                    ✅ Imagem exportada!
                </div>
                </section>
                `;
    }

    function exportImage() {
        var btnExport = document.querySelector('#slide-content button[onclick="exportImage()"]');
        var feedback = document.getElementById('exportFeedback');
        var loadingElement = document.getElementById('loading');

        if (loadingElement) loadingElement.style.display = "block";
        if (btnExport) btnExport.disabled = true;
        if (feedback) feedback.style.display = "none";

        // Usar rendercomplete do OL
        map.once('rendercomplete', function (event) {
            var mapCanvas = document.createElement('canvas');
            var size = map.getSize();
            mapCanvas.width = size[0];
            mapCanvas.height = size[1];
            var mapContext = mapCanvas.getContext('2d');

            // 🔧 Pegar TODOS os canvases, inclusive os vetoriais
            Array.prototype.forEach.call(
                map.getViewport().querySelectorAll('.ol-layer canvas'),
                function (canvas) {
                    if (canvas.width > 0) {
                        var opacity = canvas.parentNode.style.opacity;
                        mapContext.globalAlpha = opacity === '' ? 1 : Number(opacity);

                        // Aplicar transformações
                        var transform = canvas.style.transform;
                        var matrix = transform.match(/^matrix\(([^\(]*)\)$/);
                        if (matrix) {
                            var parts = matrix[1].split(',').map(Number);
                            mapContext.setTransform(parts[0], parts[1], parts[2], parts[3], parts[4], parts[5]);
                        } else {
                            mapContext.setTransform(1, 0, 0, 1, 0, 0);
                        }

                        mapContext.drawImage(canvas, 0, 0);
                    }
                }
            );


            // Gerar imagem final
            var imgURL = mapCanvas.toDataURL('image/png');
            var link = document.createElement('a');
            link.href = imgURL;
            link.download = 'mapa.png';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);

            if (loadingElement) loadingElement.style.display = "none";

            if (feedback) {
                feedback.style.display = "block";
                setTimeout(() => {
                    feedback.style.display = "none";
                    if (btnExport) btnExport.disabled = false;
                }, 3000);
            } else if (btnExport) {
                btnExport.disabled = false;
            }
        });

        map.renderSync();
    }

    // Expor globalmente
    window.openExportPanel = openExportPanel;
    window.exportImage = exportImage;
})();
