// Exemplo de como manipular a exibição com JavaScript
document.addEventListener('DOMContentLoaded', function() {
    var userGroupId = 1;
    
    // Controla a exibição de ações baseadas no grupo do usuário
    if (userGroupId === 1) {
        document.getElementById('admin-actions').style.display = 'block';
    } else if (userGroupId === 2) {
        document.getElementById('client-actions').style.display = 'block';
    }
    
    // Função para verificar se o usuário está logado
    function isLoggedIn() {
        return sessionStorage.setItem("userLoggedIn", "true");
    }
    
    });

// ===== Camadas Base =====
var googleHybrid = L.tileLayer('https://mt1.google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 22 });
var wmsJequieLayer = createWMSLayer('sisprom:jequie_full_gsd06cm_2025_total');

// ===== Camadas WMS =====
var wmsQuadraLayer = createWMSLayer('sisprom:QUADRA_PINDORAMA');
var wmsRuasLayer = createWMSLayer('sisprom:ruas_jequie_2023_wgs84');
var wmsRotuloLoteLayer = createWMSLayer('sisprom:CADASTRO_GERAL_2025_ROTULO');
var wmsCorredoresdeUsoDiversificadoILayer = createWMSLayer('sisprom:Corredores_de_Uso_Diversificado_I');
var wmsCorredoresdeUsoDiversificadoIILayer = createWMSLayer('sisprom:Corredores_de_Uso_Diversificado_II');
var wmsCampusUniversitarioLayer = createWMSLayer('sisprom:Campus_Universitário');
var wmsCentroHistoricoLayer = createWMSLayer('sisprom:Centro_Histórico');
var wmsCentroInstitucionalMunicipalLayer = createWMSLayer('sisprom:Centro_Institucional_Municipal');
var wmsCentroTradicionalMunicipalLayer = createWMSLayer('sisprom:Centro_Tradicional_Municipal');
var wmsDistritoIndustrialILayer = createWMSLayer('sisprom:Distrito_Industrial_I');
var wmsDistritoIndustrialIILayer = createWMSLayer('sisprom:Distrito_Industrial_II');
var wmsParquedaCidadeLayer = createWMSLayer('sisprom:Parque_da_Cidade');
var wmsZR1Layer = createWMSLayer('sisprom:ZR-1');
var wmsZR2Layer = createWMSLayer('sisprom:ZR-2');
var wmsZR3Layer = createWMSLayer('sisprom:ZR-3');
var wmsZR4Layer = createWMSLayer('sisprom:ZR-4');
var wmsZR5Layer = createWMSLayer('sisprom:ZR-5');

// Terceira camada WMS para o logradouro de Jequié
var wmsImoveisLayer = L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
    layers: 'sisprom:imoveis_jequie',
    format: 'image/png',
    transparent: true,
    version: '1.1.0',
    srs: 'EPSG:32724',
    minZoom: 10,
    maxZoom: 22
});
// Função para criar camadas de pavimentos dinamicamente com filtros
function criarCamadapavimentos(pavimentos) {
    return L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
        layers: 'sisprom:imoveis_jequie',
        format: 'image/png',
        transparent: true,
        version: '1.1.0',
        cql_filter: `pavimentos='${pavimentos}'`, // Filtro CQL para pavimentos
        srs: 'EPSG:32724',
        minZoom: 10,
        maxZoom: 22
    });
}
// Criar camadas para cada pavimentos
var pavimentosP0 = criarCamadapavimentos('P-0');
var pavimentosP1 = criarCamadapavimentos('P-1');
var pavimentosP2 = criarCamadapavimentos('P-2');
var pavimentosP3 = criarCamadapavimentos('P-3');

// Segunda camada WMS para o contorno de Jequié
var wmsCadastroTributos = L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
    layers: 'sisprom:Jequie_2025_postgis',
    format: 'image/png',
    transparent: true,
    version: '1.1.0',
    srs: 'EPSG:32724',
    minZoom: 10,
    maxZoom: 22
});

// ===== Inicializa o Mapa =====
var map = L.map("map", {
    center: [-13.8607, -40.0786],
    zoom: 14,
    minZoom: 10,
    maxZoom: 22,
    zoomControl: false,
    editable: true,
    layers: [wmsJequieLayer]
});

// Adiciona a camada WMS do contorno
wmsCadastroTributos.addTo(map);

// ===== Adiciona controle de zoom =====
var zoom_bar = new L.Control.ZoomBar({ position: 'topleft' }).addTo(map);

// ===== Adiciona controle de scale =====
L.control.scale().addTo(map);
map.on('mousemove', updateCoordinates);

// ===== Estilos =====
var defaultWFSStyle = { color: '#0000FF', weight: 1, opacity: 0.5, fillOpacity: 0.05 };
var corretoStyle = { color: '#00FF00', weight: 1, opacity: 0.8, fillOpacity: 0.2 };  // Verde para "Correto"
var atualizarStyle = { color: '#FF0000', weight: 1, opacity: 0.8, fillOpacity: 0.2 }; // Vermelho para "Atualizar"

// ===== Camadas WFS =====
var wfsLayer = L.geoJSON(null, { onEachFeature: onEachWFSFeature, style: defaultWFSStyle });
var corretoLayer = L.geoJSON(null, { onEachFeature: onEachWFSFeature, style: corretoStyle });
var atualizarLayer = L.geoJSON(null, { onEachFeature: onEachWFSFeature, style: atualizarStyle });

loadWFS();

// ===== Controle de Camadas =====
var groupedOverlays = {
    "MAPA BASE": {
        "Mapa Base": wfsLayer,
        "Correto": corretoLayer,
        "Atualizar": atualizarLayer
    },
    "IMÓVEIS": {
                "Todos os Imóveis": wmsImoveisLayer,
                "pavimentos P-0": pavimentosP0,
                "pavimentos P-1": pavimentosP1,
                "pavimentos P-2": pavimentosP2,
                "pavimentos P-3": pavimentosP3
            },
    "OUTRAS CAMADAS": {
        "Ruas/Avenidas": wmsRuasLayer,
        "Lotes": wmsRotuloLoteLayer,
        "Quadras": wmsQuadraLayer
    },
    "Plano Diretor Municipal": {
        "Corredores de Uso Diversificado I": wmsCorredoresdeUsoDiversificadoILayer,
        "Corredores de Uso Diversificado II": wmsCorredoresdeUsoDiversificadoIILayer,
        "Campus Universitário": wmsCampusUniversitarioLayer,
        "Centro Histórico": wmsCentroHistoricoLayer,
        "Centro Institucional Municipal": wmsCentroInstitucionalMunicipalLayer,
        "Centro Tradicional Municipal": wmsCentroTradicionalMunicipalLayer,
        "Distrito Industrial I": wmsDistritoIndustrialILayer,
        "Distrito Industrial II": wmsDistritoIndustrialIILayer,
        "Parque da Cidade": wmsParquedaCidadeLayer,
        "ZR - 01": wmsZR1Layer,
        "ZR - 02": wmsZR2Layer,
        "ZR - 03": wmsZR3Layer,
        "ZR - 04": wmsZR4Layer,
        "ZR - 05": wmsZR5Layer
    }
};

var controlLayers = L.control.groupedLayers(
    { "Google Hybrid": googleHybrid, "Ortophoto Jan2024": wmsJequieLayer },
    groupedOverlays,
    { collapsed: window.innerWidth < 768 }
).addTo(map);

map.addLayer(wfsLayer);
map.addLayer(wmsRuasLayer);
map.addLayer(wmsRotuloLoteLayer);

// ===== Funções Auxiliares =====
function createWMSLayer(layerName) {
    return L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
        layers: layerName,
        format: 'image/png',
        transparent: true,
        version: '1.1.0',
        srs: 'EPSG:32724',
        minZoom: 10,
        maxZoom: 22
    });
}

function updateCoordinates(e) {
    document.getElementById('map_coords').innerHTML = `
        <strong>Lat:</strong> ${e.latlng.lat.toFixed(4)}
        <strong>Long:</strong> ${e.latlng.lng.toFixed(4)}
        <strong>Zoom:</strong> ${map.getZoom()}`;
}

// ===== Função para carregar WFS =====
function loadWFS() {
    fetch('https://sisprom-br.com.br:8443/geoserver/sisprom/wfs?service=WFS&version=2.0.0&request=GetFeature&typeNames=sisprom:Jequie_2025_postgis&outputFormat=application/json&srsName=EPSG:4326')
        .then(response => response.json())
        .then(data => {
            wfsLayer.addData(data);

            // Separar os dados entre "Correto" e "Atualizar"
            data.features.forEach(feature => {
                if (feature.properties.situacao === "CORRETO") {
                    corretoLayer.addData(feature);
                } else if (feature.properties.situacao === "ATUALIZAR") {
                    atualizarLayer.addData(feature);
                }
            });

            console.log("Dados WFS carregados.");

            if (inscricao) {
                setTimeout(() => highlightInscricao(inscricao), 500);
            }
        })
        .catch(error => console.error('Erro ao carregar WFS:', error));
}

function onEachWFSFeature(feature, layer) {
    layer.on('click', (e) => highlightFeature(layer, e.latlng));
}

// ===== Destaque de Polígono =====
var highlightedLayer = null;
function highlightFeature(layer, latlng) {
    if (highlightedLayer) wfsLayer.resetStyle(highlightedLayer);
    layer.setStyle({ color: '#FF0000', weight: 3, opacity: 0.7, fillOpacity: 0.1 });
    highlightedLayer = layer;
    map.setView(latlng, 19);
}

// ===== Obtém a inscrição =====
// Função para obter parâmetros da URL
function getQueryParam(param) {
    let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}
// Aguarde até que o GeoJSON seja completamente carregado
function highlightInscricao(inscricao) {
    let found = false;

    wfsLayer.eachLayer(layer => {
        if (layer.feature && layer.feature.properties.inscricao === inscricao) {
            let bounds = layer.getBounds(); // Obtém os limites do polígono

            if (bounds.isValid()) { // Verifica se os limites são válidos
                found = true;
                let center = bounds.getCenter(); // Obtém o centro do polígono

                map.setView(center, 19); // Define o zoom fixo para 19

                layer.setStyle({
                    fillColor: 'yellow',
                    color: 'red',
                    weight: 3,
                    fillOpacity: 0.7
                });
                // Simula um clique no polígono para abrir as informações
                layer.fire('click');
            } else {
                console.warn("Os limites do polígono são inválidos para a inscrição:", inscricao);
            }
        }
    });

    if (!found) {
        console.warn("Inscrição não encontrada no WFS:", inscricao);
    }
}

// Obtém a inscrição da URL e aguarda o carregamento
var inscricao = getQueryParam("inscricao");

// ===== SidePanel =====
function openNav(contentInfo, contentOther) {
    document.getElementById("sidePanel").style.width = "350px";
    document.getElementById("panelContentInfo").innerHTML = contentInfo;
    document.getElementById("panelContentOther").innerHTML = contentOther;
}

function closeSearchPanel() {
    document.getElementById("searchPanel").style.width = "0";
}

function closeNav() {
    document.getElementById("sidePanel").style.width = "0";
}

function openTab(evt, tabName) {
    evt.preventDefault(); // Prevenir o comportamento padrão do clique
    var i, tabcontent, tablinks;
    tabcontent = document.getElementsByClassName("tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tablinks = document.getElementsByClassName("tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
    }
    document.getElementById(tabName).style.display = "block";
    evt.currentTarget.className += " active";
}
// Abrir a aba 'Info' por padrão
document.addEventListener('DOMContentLoaded', function () {
    document.getElementsByClassName('tablinks')[0].click();
});

// Variável para armazenar o polígono selecionado
var selectedLayer = null;
// Função para manipular o clique no polígono e buscar informações via AJAX
function zoomToFeature(e) {
    var layer = e.target;

    if (!layer.feature) {
        console.error("A camada clicada não possui uma feature associada.");
        return;
    }

    var properties = layer.feature.properties;

    if (!properties) {
        console.error("Propriedades do polígono não encontradas.");
        return;
    }

    var zoomLevel = 20;
    map.setView(layer.getBounds().getCenter(), zoomLevel);

    if (selectedLayer) {
        selectedLayer.setStyle({
            fillColor: '#0000FF',
            fillOpacity: 0.2
        });
    }

    selectedLayer = layer;
    selectedLayer.setStyle({
        fillColor: '#FFFF00',
        fillOpacity: 0.7
    });
}

// Inicializar a variável contentInfo globalmente
wfsLayer.on('click', function (e) {
    if (!e.layer || !e.layer.feature || !e.layer.feature.properties) {
        console.error("Propriedades do polígono não encontradas.");
        return;
    }

    var properties = e.layer.feature.properties;
    var inscricao = properties.inscricao;
    var contentInfo = "";
    var contentOther = "";

    $.ajax({
        url: 'vendor/geojequie/consulta_inscricao_el.php',
        type: 'GET',
        data: { inscricao: inscricao },
        success: function (data) {
            if (typeof data === 'string') {
                try {
                    data = JSON.parse(data);
                } catch (e) {
                    console.error('Erro ao analisar a resposta JSON:', e);
                    return;
                }
            }

            contentInfo = `
                        <div class="row small text-center">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover table-sm table-sidebar" style="margin-bottom:15px;">
                                        <thead class="thead-dark">
                                            <tr><th colspan="2" class="text-center text-custom-color">🔹 Contribuinte</th></tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="text-left"><strong>Proprietário</strong></td>
                                                <td class="text-left">${properties.situacao || "N/A"}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Inscrição</strong></td>                           
                                                <td class="text-left">${inscricao}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Bairro</strong></td>
                                                <td class="text-left">${data.bairro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Quadra</strong></td>
                                                <td class="text-left">${data.imobiliario?.quadra || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Logradouro</strong></td>
                                                <td class="text-left">${data.logradouro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Nº</strong></td>                            
                                                <td class="text-left">${data?.numero || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Utilização</strong></td>
                                                <td class="text-left">${data.imobiliario?.boletim?.[0]?.resposta?.descricao || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Lote</strong></td>                            
                                                <td class="text-left">${data.imobiliario?.lote || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Situação</strong></td>
                                                <td class="text-left">${properties.situacao || "N/A"}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>                                        
                                    <button class="tablinks" id="generarPDF">
                                        <i class="fas fa-file-pdf"></i> Gerar PDF
                                    </button>                                            
                                </div>                                        
                        </div>`;

            document.getElementById('panelContentInfo').innerHTML = contentInfo;
            // Variável para armazenar o marcador atual
            var currentMarker = null;

            document.getElementById('generarPDF').addEventListener('click', function (event) {
                event.preventDefault();
                // Exibi animação de carregamento
                document.getElementById('loading').style.display = 'flex';
                // Verifica se já existe um marcador, em caso afirmativo, remove
                if (currentMarker) {
                    map.removeLayer(currentMarker);
                }
                // Usa a latitude e a longitude do objeto properties
                var markerLatLng = L.latLng(properties.latitude, properties.longitude);
                // Adiciona um novo marcador na latitude e longitude especificadas
                currentMarker = L.marker(markerLatLng).addTo(map);

                leafletImage(map, function (err, canvas) {
                    if (err) {
                        console.error('Erro ao capturar imagem do mapa:', err);
                        return;
                    }
                    // Remove o marcador depois que a imagem for capturada
                    map.removeLayer(currentMarker);
                    currentMarker = null;

                    toDataURL('brasao_Jequie.png', function (logo) {
                        // Cria uma nova janela para o modelo PDF
                        var pdfWindow = window.open('', '_blank');
                        pdfWindow.document.write('<html><head><title>PDF Template</title></head><body></body></html>');
                        // Carrega o modelo HTML na nova janela
                        fetch('./app/resources/pdf_template_imobiliario.html')
                            .then(response => response.text())
                            .then(template => {
                                pdfWindow.document.body.innerHTML = template;
                                // Atualizar elementos do template com dados
                                const setElementText = (selector, text) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.textContent = text || 'N/A';
                                };
                                const setElementSrc = (selector, src) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.src = src;
                                };

                                setElementSrc('#logo', logo);
                                setElementText('#properties\\.name', properties.name);
                                setElementText('#inscricao', inscricao);
                                setElementText('#data\\.imobiliario\\.matricula', data.imobiliario?.matricula);
                                setElementText('#data\\.codigo', data.codigo);
                                setElementText('#data\\.imobiliario\\.distrito', data.imobiliario?.distrito);
                                setElementText('#data\\.imobiliario\\.setor', data.imobiliario?.setor);
                                setElementText('#data\\.imobiliario\\.quadra', data.imobiliario?.quadra);
                                setElementText('#data\\.imobiliario\\.lote', data.imobiliario?.lote);
                                setElementText('#data\\.imobiliario\\.unidade', data.imobiliario?.unidade);
                                setElementText('#data\\.imobiliario\\.situacao\\.descricao',
                                    data.imobiliario.situacao.descricao || 'Estado desconhecido');
                                    function formatarDataBrasileira(dataISO) {
                                        if (!dataISO) return 'N/A';
                                        const data = new Date(dataISO);
                                        const dia = String(data.getDate()).padStart(2, '0');
                                        const mes = String(data.getMonth() + 1).padStart(2, '0');
                                        const ano = data.getFullYear();
                                        return `${dia}/${mes}/${ano}`;
                                      }
                                      
                                      const dataCadastro = formatarDataBrasileira(data?.dataInclusao);
                                      
                                      setElementText('#data\\.dataInclusao', dataCadastro);
                                setElementText('#data\\.logradouro\\.nome', data.logradouro?.nome);
                                setElementText('#data\\.numero', data.numero);
                                setElementText('#data\\.imobiliario\\.complemento', data.imobiliario?.complemento);
                                setElementText('#data\\.bairro\\.nome', data.bairro?.nome);
                                setElementText('#data\\.cidade\\.nome', data.cidade?.nome);
                                setElementText('#data\\.cidade\\.tipo\\.sigla', data.cidade.tipo.sigla);
                                setElementText('#data\\.cep', data.cep);
                                const campo9005 = data.imobiliario?.boletim?.find(b => b.campo === "9005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9005\\]\\.resposta\\.descricao', campo9005);
                                const campo9001 = data.imobiliario?.boletim?.find(b => b.campo === "9001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9001\\]\\.resposta\\.descricao', campo9001);
                                const campo9002 = data.imobiliario?.boletim?.find(b => b.campo === "9002")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9002\\]\\.resposta\\.descricao', campo9002);
                                const campo1001 = data.imobiliario?.boletim?.find(b => b.campo === "1001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1001\\]\\.resposta\\.descricao', campo1001);
                                const campo1003 = data.imobiliario?.boletim?.find(b => b.campo === "1003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1003\\]\\.resposta\\.descricao', campo1003);
                                const campo2001 = data.imobiliario?.boletim?.find(b => b.campo === "2001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2001\\]\\.resposta\\.descricao', campo2001);
                                const campo2004 = data.imobiliario?.boletim?.find(b => b.campo === "2004")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2004\\]\\.resposta\\.descricao', campo2004);
                                const campo2006 = data.imobiliario?.boletim?.find(b => b.campo === "2006")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2006\\]\\.resposta\\.descricao', campo2006);
                                const campo2003 = data.imobiliario?.boletim?.find(b => b.campo === "2003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2003\\]\\.resposta\\.descricao', campo2003);
                                const campo2005 = data.imobiliario?.boletim?.find(b => b.campo === "2005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2005\\]\\.resposta\\.descricao', campo2005);

                                var mapImage = canvas.toDataURL('image/png');
                                pdfWindow.document.getElementById('mapImage').src = mapImage;
                                // Gera PDF a partir do conteúdo na janela usando html2canvas e jsPDF
                                setTimeout(() => {
                                    html2canvas(pdfWindow.document.body).then(canvas => {
                                        const { jsPDF } = window.jspdf;
                                        const doc = new jsPDF();
                                        const imgData = canvas.toDataURL('image/png');
                                        const imgProps = doc.getImageProperties(imgData);
                                        const pdfWidth = doc.internal.pageSize.getWidth();
                                        const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                        doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                        // Ocultar o loading após gerar o PDF
                                        document.getElementById('loading').style.display = 'none';
                                    });
                                }, 1000);
                            })
                            .catch(error => console.error('Erro ao carregar template:', error));
                    });
                });
            });
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error('Erro ao buscar dados:', textStatus, errorThrown);
        }
    });
    // Converte imagem em base64
    function toDataURL(url, callback) {
        var xhr = new XMLHttpRequest();
        xhr.onload = function () {
            var reader = new FileReader();
            reader.onloadend = function () {
                callback(reader.result);
            };
            reader.readAsDataURL(xhr.response);
        };
        xhr.open('GET', url);
        xhr.responseType = 'blob';
        xhr.send();
    }
    // Constroi contentOther de geoJsonLayer
    contentOther += '<div class="row small text-center table-container">' +
        '<div class="col-md-12">' +
        '<div class="table-responsive">' +
        '<table class="table table-bordered table-hover table-sm table-sidebar">' +
        '<thead class="thead-dark">' +
        '<tr><th colspan="2" class="text-center text-custom-color">📌 Parâmetros de Uso e Ocupação</th>' +
        '</thead>' +
        '<tbody>' +
        '<tr><td class="text-left"><strong>Proprietário</strong></td><td class="text-left text-custom-color">' + (properties.name || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Inscrição</strong></td><td class="text-left text-custom-color">' + inscricao + '</td></tr>' +
        '<tr><td class="text-left"><strong>Utilização</strong></td><td class="text-left text-custom-color">' + (properties.utilizacao || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Zoneamento</strong></td><td class="text-left text-custom-color" id="zoneamentoValue2">' + (properties.zoneamento || "N/A") + '</td></tr>' +
        '</tbody>' +
        '</table>' +
        '</div>' +
        '<div class="col-md-12" id="cnaeFieldsContainer" style="margin-top: 10px;">' +
        '<div class="cnae-field">' +
        '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
        '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
        '<div class="cnaeResult"></div>' +
        '</div>' +
        '</div>' +
        '<div class="col-md-12" style="margin-top: 10px;">' +
        '<button id="addCNAEButton"><i class="fas fa-plus"></i> Adicionar CNAE</button>' +
        '</div>' +
        '<div class="col-md-12 text-center" style="margin-top: 10px;">' +
        '<button class="tablinks" id="generatePDF">' +
        '<i class="fas fa-file-pdf"></i> Consulta' +
        ' </button> ' +
        '</div>' +
        '</div>' +
        '</div>';
    // Função para anexar ouvintes de eventos
    function attachEventListeners() {
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
    // Função para pesquisar CNAE
    function pesquisarCNAE(button) {
        var cnaeInput = button.previousElementSibling;
        var cnae = cnaeInput.value;
        var zonaElement = document.getElementById('zoneamentoValue2');
        if (!zonaElement) {
            alert('O elemento de zoneamento não foi encontrado.');
            return;
        }

        var zona = zonaElement.textContent;
        if (!cnae || !zona) {
            alert('Por favor, preencha o CNAE e a zona.');
            return;
        }

        fetch('check_cnae.php?cnae=' + cnae + '&zoneamento=' + zona)
            .then(response => response.json())
            .then(data => {
                var cnaeResult = button.nextElementSibling;
                cnaeResult.innerHTML = '';

                if (data.error) {
                    cnaeResult.innerHTML = `<span style="color: red;">${data.error}</span>`;
                } else {
                    let icon = data.existe
                        ? '<i class="fas fa-check-circle" style="color: green;"></i> PERMITIDO'
                        : '<i class="fas fa-times-circle" style="color: red;"></i> NÃO PERMITIDO';

                    let grauRiscoText = `<br><strong>Grau de Risco:</strong> ${data.grau_risco || 'N/A'}`;

                    cnaeResult.innerHTML = `${icon} - ${data.descricao} ${grauRiscoText}`;
                }
            })
            .catch(error => console.error('Erro:', error));
    }
    // Função para adicionar um novo CNAE campo
    function adicionarCNAEField() {
        var container = document.getElementById('cnaeFieldsContainer');
        var newField = document.createElement('div');
        newField.className = 'cnae-field';
        newField.innerHTML =
            '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
            '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
            '<div class="cnaeResult"></div>';

        container.appendChild(newField);

        newField.querySelector('.pesquisarCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            pesquisarCNAE(this);
        });
    }
    // Abra o painel lateral com o botão content
    openNav(contentInfo, contentOther);
    // Simule um clique na guia "Info" para abri-la por padrão
    document.getElementsByClassName('tablinks')[0].click();
    // anexar ouvintes de eventos aos botões CNAE e ao botão "Consulta"
    attachEventListeners();

    var currentMarker = null;

    document.getElementById('generatePDF').addEventListener('click', function (event) {
        event.preventDefault();
        // Exibir animação de carregamento
        document.getElementById('loading').style.display = 'flex';
        // Verifica se já existe um marcador, em caso afirmativo, remova-o
        if (currentMarker) {
            map.removeLayer(currentMarker);
        }
        // Usar a latitude e a longitude do objeto properties
        var markerLatLng = L.latLng(properties.latitude, properties.longitude);
        // Adicionar um novo marcador na latitude e longitude especificadas
        currentMarker = L.marker(markerLatLng).addTo(map);

        leafletImage(map, function (err, canvas) {
            if (err) {
                console.error('Erro ao capturar imagem do mapa:', err);
                return;
            }
            // Remova o marcador depois que a imagem for capturada
            map.removeLayer(currentMarker);
            currentMarker = null;

            toDataURL('brasao_Jequie.png', function (logo) {
                // criar uma nova janela para o modelo PDF
                var pdfWindow = window.open('', '_blank');
                pdfWindow.document.write('<html><head><title>Uso e Ocupação do Solo</title></head><body></body></html>');
                // Carregue o modelo HTML na nova janela
                fetch('./app/resources/pdf_template.html')
                    .then(response => response.text())
                    .then(template => {
                        pdfWindow.document.body.innerHTML = template;
                        // Acesse e atualize elementos com segurança
                        const logoElement = pdfWindow.document.getElementById('logo');
                        if (logoElement) {
                            logoElement.src = logo;
                        }
                        const nameElement = pdfWindow.document.getElementById('properties.name');
                        if (nameElement) {
                            nameElement.textContent = properties.name;
                        }
                        const inscricaoElement = pdfWindow.document.getElementById('inscricao');
                        if (inscricaoElement) {
                            inscricaoElement.textContent = inscricao;
                        }
                        const zoneamentoElement = pdfWindow.document.getElementById('properties.zoneamento');
                        if (zoneamentoElement) {
                            zoneamentoElement.textContent = properties.zoneamento;
                        }
                        const bairroElement = pdfWindow.document.getElementById('properties.bairro');
                        if (bairroElement) {
                            bairroElement.textContent = properties.bairro;
                        }
                        const logradouroElement = pdfWindow.document.getElementById('properties.logradouro');
                        if (logradouroElement) {
                            logradouroElement.textContent = properties.logradouro;
                        }
                        const numero_lotElement = pdfWindow.document.getElementById('properties.numero_lot');
                        if (numero_lotElement) {
                            numero_lotElement.textContent = properties.numero_lot;
                        }
                        const quadraElement = pdfWindow.document.getElementById('properties.quadra');
                        if (quadraElement) {
                            quadraElement.textContent = properties.quadra;
                        }
                        const loteElement = pdfWindow.document.getElementById('properties.lote');
                        if (loteElement) {
                            loteElement.textContent = properties.lote;
                        }

                        var cnaeFields = document.querySelectorAll('.cnae-field');
                        var cnaeResults = pdfWindow.document.getElementById('cnaeResults');

                        cnaeFields.forEach(field => {
                            var cnaeInput = field.querySelector('.cnaeInput').value;
                            var cnaeFullText = field.querySelector('.cnaeResult').textContent.trim();
                            // Ajuste na extração do resultado e grau de risco
                            var resultadoMatch = cnaeFullText.match(/(PERMITIDO|NÃO PERMITIDO)\s*-\s*(.+?)(?=\s*Grau de Risco|$)/);
                            var grauRiscoMatch = cnaeFullText.match(/Grau de Risco:\s*(.+)/);

                            var resultadoTexto = resultadoMatch
                                ? resultadoMatch[1] + (resultadoMatch[2] && resultadoMatch[2] !== "undefined" ? " - " + resultadoMatch[2].trim() : "")
                                : "N/A";
                            var grauRisco = grauRiscoMatch ? grauRiscoMatch[1] : "N/A";
                            // Criar a linha da tabela
                            var row = pdfWindow.document.createElement('tr');

                            var inputCell = pdfWindow.document.createElement('td');
                            inputCell.textContent = cnaeInput || "N/A";

                            var resultCell = pdfWindow.document.createElement('td');
                            resultCell.textContent = resultadoTexto;

                            var riscoCell = pdfWindow.document.createElement('td');
                            riscoCell.textContent = grauRisco;
                            // Aplicar classes de estilo corretamente
                            if (resultadoTexto.startsWith('NÃO PERMITIDO')) {
                                resultCell.classList.add('not-allowed'); // Vermelho para "NÃO PERMITIDO"
                            } else if (resultadoTexto.startsWith('PERMITIDO')) {
                                resultCell.classList.add('allowed'); // Verde para "PERMITIDO"
                            }
                            // Adicionar células à linha
                            row.appendChild(inputCell);
                            row.appendChild(resultCell);
                            row.appendChild(riscoCell);
                            // Adicionar a linha à tabela
                            cnaeResults.appendChild(row);
                        });

                        var mapImage = canvas.toDataURL('image/png');
                        pdfWindow.document.getElementById('mapImage').src = mapImage;
                        // Gere PDF a partir do conteúdo da nova janela usando html2canvas e jsPDF
                        setTimeout(() => {
                            html2canvas(pdfWindow.document.body).then(canvas => {
                                const { jsPDF } = window.jspdf;
                                const doc = new jsPDF();
                                const imgData = canvas.toDataURL('image/png');
                                const imgProps = doc.getImageProperties(imgData);
                                const pdfWidth = doc.internal.pageSize.getWidth();
                                const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                // Ocultar o loading após gerar o PDF
                                document.getElementById('loading').style.display = 'none';
                            });
                        }, 1000);
                    })
                    .catch(error => console.error('Erro ao carregar template:', error));
            });
        });
    });

    function attachEventListeners() {
        // Ouvinte de eventos de botões CNAE existente
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
},
);

// Inicializar a variável contentInfo globalmente
atualizarLayer.on('click', function (e) {
    if (!e.layer || !e.layer.feature || !e.layer.feature.properties) {
        console.error("Propriedades do polígono não encontradas.");
        return;
    }

    var properties = e.layer.feature.properties;
    var inscricao = properties.inscricao;
    var contentInfo = "";
    var contentOther = "";

    $.ajax({
        url: 'vendor/geojequie/consulta_inscricao_el.php',
        type: 'GET',
        data: { inscricao: inscricao },
        success: function (data) {
            if (typeof data === 'string') {
                try {
                    data = JSON.parse(data);
                } catch (e) {
                    console.error('Erro ao analisar a resposta JSON:', e);
                    return;
                }
            }

            contentInfo = `
                        <div class="row small text-center">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover table-sm table-sidebar" style="margin-bottom:15px;">
                                        <thead class="thead-dark">
                                            <tr><th colspan="2" class="text-center text-custom-color">🔹 Contribuinte</th></tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="text-left"><strong>Proprietário</strong></td>
                                                <td class="text-left">${properties.name || "N/A"}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Inscrição</strong></td>                           
                                                <td class="text-left">${inscricao}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Bairro</strong></td>
                                                <td class="text-left">${data.bairro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Quadra</strong></td>
                                                <td class="text-left">${data.imobiliario?.quadra || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Logradouro</strong></td>
                                                <td class="text-left">${data.logradouro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Nº</strong></td>                            
                                                <td class="text-left">${data?.numero || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Utilização</strong></td>
                                                <td class="text-left">${data.imobiliario?.boletim?.[0]?.resposta?.descricao || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Lote</strong></td>                            
                                                <td class="text-left">${data.imobiliario?.lote || 'N/A'}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>                                        
                                    <button class="tablinks" id="generarPDF">
                                        <i class="fas fa-file-pdf"></i> Gerar PDF
                                    </button>                                            
                                </div>                                        
                        </div>`;

            document.getElementById('panelContentInfo').innerHTML = contentInfo;
            // Variável para armazenar o marcador atual
            var currentMarker = null;

            document.getElementById('generarPDF').addEventListener('click', function (event) {
                event.preventDefault();
                // Exibi animação de carregamento
                document.getElementById('loading').style.display = 'flex';
                // Verifica se já existe um marcador, em caso afirmativo, remove
                if (currentMarker) {
                    map.removeLayer(currentMarker);
                }
                // Usa a latitude e a longitude do objeto properties
                var markerLatLng = L.latLng(properties.latitude, properties.longitude);
                // Adiciona um novo marcador na latitude e longitude especificadas
                currentMarker = L.marker(markerLatLng).addTo(map);

                leafletImage(map, function (err, canvas) {
                    if (err) {
                        console.error('Erro ao capturar imagem do mapa:', err);
                        return;
                    }
                    // Remove o marcador depois que a imagem for capturada
                    map.removeLayer(currentMarker);
                    currentMarker = null;

                    toDataURL('brasao_Jequie.png', function (logo) {
                        // Cria uma nova janela para o modelo PDF
                        var pdfWindow = window.open('', '_blank');
                        pdfWindow.document.write('<html><head><title>PDF Template</title></head><body></body></html>');
                        // Carrega o modelo HTML na nova janela
                        fetch('./app/resources/pdf_template_imobiliario.html')
                            .then(response => response.text())
                            .then(template => {
                                pdfWindow.document.body.innerHTML = template;
                                // Atualizar elementos do template com dados
                                const setElementText = (selector, text) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.textContent = text || 'N/A';
                                };
                                const setElementSrc = (selector, src) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.src = src;
                                };

                                setElementSrc('#logo', logo);
                                setElementText('#properties\\.name', properties.name);
                                setElementText('#inscricao', inscricao);
                                setElementText('#data\\.imobiliario\\.matricula', data.imobiliario?.matricula);
                                setElementText('#data\\.codigo', data.codigo);
                                setElementText('#data\\.imobiliario\\.distrito', data.imobiliario?.distrito);
                                setElementText('#data\\.imobiliario\\.setor', data.imobiliario?.setor);
                                setElementText('#data\\.imobiliario\\.quadra', data.imobiliario?.quadra);
                                setElementText('#data\\.imobiliario\\.lote', data.imobiliario?.lote);
                                setElementText('#data\\.imobiliario\\.unidade', data.imobiliario?.unidade);
                                setElementText('#data\\.imobiliario\\.situacao\\.descricao',
                                    data.imobiliario.situacao.descricao || 'Estado desconhecido');
                                    function formatarDataBrasileira(dataISO) {
                                        if (!dataISO) return 'N/A';
                                        const data = new Date(dataISO);
                                        const dia = String(data.getDate()).padStart(2, '0');
                                        const mes = String(data.getMonth() + 1).padStart(2, '0');
                                        const ano = data.getFullYear();
                                        return `${dia}/${mes}/${ano}`;
                                      }
                                      
                                      const dataCadastro = formatarDataBrasileira(data?.dataInclusao);
                                      
                                      setElementText('#data\\.dataInclusao', dataCadastro);
                                setElementText('#data\\.logradouro\\.nome', data.logradouro?.nome);
                                setElementText('#data\\.numero', data.numero);
                                setElementText('#data\\.imobiliario\\.complemento', data.imobiliario?.complemento);
                                setElementText('#data\\.bairro\\.nome', data.bairro?.nome);
                                setElementText('#data\\.cidade\\.nome', data.cidade?.nome);
                                setElementText('#data\\.cidade\\.tipo\\.sigla', data.cidade.tipo.sigla);
                                setElementText('#data\\.cep', data.cep);
                                const campo9005 = data.imobiliario?.boletim?.find(b => b.campo === "9005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9005\\]\\.resposta\\.descricao', campo9005);
                                const campo9001 = data.imobiliario?.boletim?.find(b => b.campo === "9001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9001\\]\\.resposta\\.descricao', campo9001);
                                const campo9002 = data.imobiliario?.boletim?.find(b => b.campo === "9002")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9002\\]\\.resposta\\.descricao', campo9002);
                                const campo1001 = data.imobiliario?.boletim?.find(b => b.campo === "1001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1001\\]\\.resposta\\.descricao', campo1001);
                                const campo1003 = data.imobiliario?.boletim?.find(b => b.campo === "1003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1003\\]\\.resposta\\.descricao', campo1003);
                                const campo2001 = data.imobiliario?.boletim?.find(b => b.campo === "2001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2001\\]\\.resposta\\.descricao', campo2001);
                                const campo2004 = data.imobiliario?.boletim?.find(b => b.campo === "2004")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2004\\]\\.resposta\\.descricao', campo2004);
                                const campo2006 = data.imobiliario?.boletim?.find(b => b.campo === "2006")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2006\\]\\.resposta\\.descricao', campo2006);
                                const campo2003 = data.imobiliario?.boletim?.find(b => b.campo === "2003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2003\\]\\.resposta\\.descricao', campo2003);
                                const campo2005 = data.imobiliario?.boletim?.find(b => b.campo === "2005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2005\\]\\.resposta\\.descricao', campo2005);

                                var mapImage = canvas.toDataURL('image/png');
                                pdfWindow.document.getElementById('mapImage').src = mapImage;
                                // Gera PDF a partir do conteúdo na janela usando html2canvas e jsPDF
                                setTimeout(() => {
                                    html2canvas(pdfWindow.document.body).then(canvas => {
                                        const { jsPDF } = window.jspdf;
                                        const doc = new jsPDF();
                                        const imgData = canvas.toDataURL('image/png');
                                        const imgProps = doc.getImageProperties(imgData);
                                        const pdfWidth = doc.internal.pageSize.getWidth();
                                        const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                        doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                        // Ocultar o loading após gerar o PDF
                                        document.getElementById('loading').style.display = 'none';
                                    });
                                }, 1000);
                            })
                            .catch(error => console.error('Erro ao carregar template:', error));
                    });
                });
            });
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error('Erro ao buscar dados:', textStatus, errorThrown);
        }
    });
    // Converte imagem em base64
    function toDataURL(url, callback) {
        var xhr = new XMLHttpRequest();
        xhr.onload = function () {
            var reader = new FileReader();
            reader.onloadend = function () {
                callback(reader.result);
            };
            reader.readAsDataURL(xhr.response);
        };
        xhr.open('GET', url);
        xhr.responseType = 'blob';
        xhr.send();
    }
    // Constroi contentOther de geoJsonLayer
    contentOther += '<div class="row small text-center table-container">' +
        '<div class="col-md-12">' +
        '<div class="table-responsive">' +
        '<table class="table table-bordered table-hover table-sm table-sidebar">' +
        '<thead class="thead-dark">' +
        '<tr><th colspan="2" class="text-center text-custom-color">📌 Parâmetros de Uso e Ocupação</th>' +
        '</thead>' +
        '<tbody>' +
        '<tr><td class="text-left"><strong>Proprietário</strong></td><td class="text-left text-custom-color">' + (properties.name || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Inscrição</strong></td><td class="text-left text-custom-color">' + inscricao + '</td></tr>' +
        '<tr><td class="text-left"><strong>Utilização</strong></td><td class="text-left text-custom-color">' + (properties.utilizacao || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Zoneamento</strong></td><td class="text-left text-custom-color" id="zoneamentoValue2">' + (properties.zoneamento || "N/A") + '</td></tr>' +
        '</tbody>' +
        '</table>' +
        '</div>' +
        '<div class="col-md-12" id="cnaeFieldsContainer" style="margin-top: 10px;">' +
        '<div class="cnae-field">' +
        '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
        '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
        '<div class="cnaeResult"></div>' +
        '</div>' +
        '</div>' +
        '<div class="col-md-12" style="margin-top: 10px;">' +
        '<button id="addCNAEButton"><i class="fas fa-plus"></i> Adicionar CNAE</button>' +
        '</div>' +
        '<div class="col-md-12 text-center" style="margin-top: 10px;">' +
        '<button class="tablinks" id="generatePDF">' +
        '<i class="fas fa-file-pdf"></i> Consulta' +
        ' </button> ' +
        '</div>' +
        '</div>' +
        '</div>';
    // Função para anexar ouvintes de eventos
    function attachEventListeners() {
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
    // Função para pesquisar CNAE
    function pesquisarCNAE(button) {
        var cnaeInput = button.previousElementSibling;
        var cnae = cnaeInput.value;
        var zonaElement = document.getElementById('zoneamentoValue2');
        if (!zonaElement) {
            alert('O elemento de zoneamento não foi encontrado.');
            return;
        }

        var zona = zonaElement.textContent;
        if (!cnae || !zona) {
            alert('Por favor, preencha o CNAE e a zona.');
            return;
        }

        fetch('check_cnae.php?cnae=' + cnae + '&zoneamento=' + zona)
            .then(response => response.json())
            .then(data => {
                var cnaeResult = button.nextElementSibling;
                cnaeResult.innerHTML = '';

                if (data.error) {
                    cnaeResult.innerHTML = `<span style="color: red;">${data.error}</span>`;
                } else {
                    let icon = data.existe
                        ? '<i class="fas fa-check-circle" style="color: green;"></i> PERMITIDO'
                        : '<i class="fas fa-times-circle" style="color: red;"></i> NÃO PERMITIDO';

                    let grauRiscoText = `<br><strong>Grau de Risco:</strong> ${data.grau_risco || 'N/A'}`;

                    cnaeResult.innerHTML = `${icon} - ${data.descricao} ${grauRiscoText}`;
                }
            })
            .catch(error => console.error('Erro:', error));
    }
    // Função para adicionar um novo CNAE campo
    function adicionarCNAEField() {
        var container = document.getElementById('cnaeFieldsContainer');
        var newField = document.createElement('div');
        newField.className = 'cnae-field';
        newField.innerHTML =
            '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
            '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
            '<div class="cnaeResult"></div>';

        container.appendChild(newField);

        newField.querySelector('.pesquisarCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            pesquisarCNAE(this);
        });
    }
    // Abra o painel lateral com o botão content
    openNav(contentInfo, contentOther);
    // Simule um clique na guia "Info" para abri-la por padrão
    document.getElementsByClassName('tablinks')[0].click();
    // anexar ouvintes de eventos aos botões CNAE e ao botão "Consulta"
    attachEventListeners();

    var currentMarker = null;

    document.getElementById('generatePDF').addEventListener('click', function (event) {
        event.preventDefault();
        // Exibir animação de carregamento
        document.getElementById('loading').style.display = 'flex';
        // Verifica se já existe um marcador, em caso afirmativo, remova-o
        if (currentMarker) {
            map.removeLayer(currentMarker);
        }
        // Usar a latitude e a longitude do objeto properties
        var markerLatLng = L.latLng(properties.latitude, properties.longitude);
        // Adicionar um novo marcador na latitude e longitude especificadas
        currentMarker = L.marker(markerLatLng).addTo(map);

        leafletImage(map, function (err, canvas) {
            if (err) {
                console.error('Erro ao capturar imagem do mapa:', err);
                return;
            }
            // Remova o marcador depois que a imagem for capturada
            map.removeLayer(currentMarker);
            currentMarker = null;

            toDataURL('brasao_Jequie.png', function (logo) {
                // criar uma nova janela para o modelo PDF
                var pdfWindow = window.open('', '_blank');
                pdfWindow.document.write('<html><head><title>Uso e Ocupação do Solo</title></head><body></body></html>');
                // Carregue o modelo HTML na nova janela
                fetch('./app/resources/pdf_template.html')
                    .then(response => response.text())
                    .then(template => {
                        pdfWindow.document.body.innerHTML = template;
                        // Acesse e atualize elementos com segurança
                        const logoElement = pdfWindow.document.getElementById('logo');
                        if (logoElement) {
                            logoElement.src = logo;
                        }
                        const nameElement = pdfWindow.document.getElementById('properties.name');
                        if (nameElement) {
                            nameElement.textContent = properties.name;
                        }
                        const inscricaoElement = pdfWindow.document.getElementById('inscricao');
                        if (inscricaoElement) {
                            inscricaoElement.textContent = inscricao;
                        }
                        const zoneamentoElement = pdfWindow.document.getElementById('properties.zoneamento');
                        if (zoneamentoElement) {
                            zoneamentoElement.textContent = properties.zoneamento;
                        }
                        const bairroElement = pdfWindow.document.getElementById('properties.bairro');
                        if (bairroElement) {
                            bairroElement.textContent = properties.bairro;
                        }
                        const logradouroElement = pdfWindow.document.getElementById('properties.logradouro');
                        if (logradouroElement) {
                            logradouroElement.textContent = properties.logradouro;
                        }
                        const numero_lotElement = pdfWindow.document.getElementById('properties.numero_lot');
                        if (numero_lotElement) {
                            numero_lotElement.textContent = properties.numero_lot;
                        }
                        const quadraElement = pdfWindow.document.getElementById('properties.quadra');
                        if (quadraElement) {
                            quadraElement.textContent = properties.quadra;
                        }
                        const loteElement = pdfWindow.document.getElementById('properties.lote');
                        if (loteElement) {
                            loteElement.textContent = properties.lote;
                        }

                        var cnaeFields = document.querySelectorAll('.cnae-field');
                        var cnaeResults = pdfWindow.document.getElementById('cnaeResults');

                        cnaeFields.forEach(field => {
                            var cnaeInput = field.querySelector('.cnaeInput').value;
                            var cnaeFullText = field.querySelector('.cnaeResult').textContent.trim();
                            // Ajuste na extração do resultado e grau de risco
                            var resultadoMatch = cnaeFullText.match(/(PERMITIDO|NÃO PERMITIDO)\s*-\s*(.+?)(?=\s*Grau de Risco|$)/);
                            var grauRiscoMatch = cnaeFullText.match(/Grau de Risco:\s*(.+)/);

                            var resultadoTexto = resultadoMatch
                                ? resultadoMatch[1] + (resultadoMatch[2] && resultadoMatch[2] !== "undefined" ? " - " + resultadoMatch[2].trim() : "")
                                : "N/A";
                            var grauRisco = grauRiscoMatch ? grauRiscoMatch[1] : "N/A";
                            // Criar a linha da tabela
                            var row = pdfWindow.document.createElement('tr');

                            var inputCell = pdfWindow.document.createElement('td');
                            inputCell.textContent = cnaeInput || "N/A";

                            var resultCell = pdfWindow.document.createElement('td');
                            resultCell.textContent = resultadoTexto;

                            var riscoCell = pdfWindow.document.createElement('td');
                            riscoCell.textContent = grauRisco;
                            // Aplicar classes de estilo corretamente
                            if (resultadoTexto.startsWith('NÃO PERMITIDO')) {
                                resultCell.classList.add('not-allowed'); // Vermelho para "NÃO PERMITIDO"
                            } else if (resultadoTexto.startsWith('PERMITIDO')) {
                                resultCell.classList.add('allowed'); // Verde para "PERMITIDO"
                            }
                            // Adicionar células à linha
                            row.appendChild(inputCell);
                            row.appendChild(resultCell);
                            row.appendChild(riscoCell);
                            // Adicionar a linha à tabela
                            cnaeResults.appendChild(row);
                        });

                        var mapImage = canvas.toDataURL('image/png');
                        pdfWindow.document.getElementById('mapImage').src = mapImage;
                        // Gere PDF a partir do conteúdo da nova janela usando html2canvas e jsPDF
                        setTimeout(() => {
                            html2canvas(pdfWindow.document.body).then(canvas => {
                                const { jsPDF } = window.jspdf;
                                const doc = new jsPDF();
                                const imgData = canvas.toDataURL('image/png');
                                const imgProps = doc.getImageProperties(imgData);
                                const pdfWidth = doc.internal.pageSize.getWidth();
                                const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                // Ocultar o loading após gerar o PDF
                                document.getElementById('loading').style.display = 'none';
                            });
                        }, 1000);
                    })
                    .catch(error => console.error('Erro ao carregar template:', error));
            });
        });
    });

    function attachEventListeners() {
        // Ouvinte de eventos de botões CNAE existente
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
},
);

// Inicializar a variável contentInfo globalmente
corretoLayer.on('click', function (e) {
    if (!e.layer || !e.layer.feature || !e.layer.feature.properties) {
        console.error("Propriedades do polígono não encontradas.");
        return;
    }

    var properties = e.layer.feature.properties;
    var inscricao = properties.inscricao;
    var contentInfo = "";
    var contentOther = "";

    $.ajax({
        url: 'vendor/geojequie/consulta_inscricao_el.php',
        type: 'GET',
        data: { inscricao: inscricao },
        success: function (data) {
            if (typeof data === 'string') {
                try {
                    data = JSON.parse(data);
                } catch (e) {
                    console.error('Erro ao analisar a resposta JSON:', e);
                    return;
                }
            }

            contentInfo = `
                        <div class="row small text-center">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-hover table-sm table-sidebar" style="margin-bottom:15px;">
                                        <thead class="thead-dark">
                                            <tr><th colspan="2" class="text-center text-custom-color">🔹 Contribuinte</th></tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class="text-left"><strong>Proprietário</strong></td>
                                                <td class="text-left">${properties.situi || "N/A"}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Inscrição</strong></td>                           
                                                <td class="text-left">${inscricao}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Bairro</strong></td>
                                                <td class="text-left">${data.bairro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Quadra</strong></td>
                                                <td class="text-left">${data.imobiliario?.quadra || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Logradouro</strong></td>
                                                <td class="text-left">${data.logradouro?.nome || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Nº</strong></td>                            
                                                <td class="text-left">${data?.numero || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Utilização</strong></td>
                                                <td class="text-left">${data.imobiliario?.boletim?.[0]?.resposta?.descricao || 'N/A'}</td>
                                            </tr>
                                            <tr>
                                                <td class="text-left"><strong>Lote</strong></td>                            
                                                <td class="text-left">${data.imobiliario?.lote || 'N/A'}</td>
                                            </tr>
                                           
                                        </tbody>
                                    </table>
                                </div>                                        
                                    <button class="tablinks" id="generarPDF">
                                        <i class="fas fa-file-pdf"></i> Gerar PDF
                                    </button>                                            
                                </div>                                        
                        </div>`;

            document.getElementById('panelContentInfo').innerHTML = contentInfo;
            // Variável para armazenar o marcador atual
            var currentMarker = null;

            document.getElementById('generarPDF').addEventListener('click', function (event) {
                event.preventDefault();
                // Exibi animação de carregamento
                document.getElementById('loading').style.display = 'flex';
                // Verifica se já existe um marcador, em caso afirmativo, remove
                if (currentMarker) {
                    map.removeLayer(currentMarker);
                }
                // Usa a latitude e a longitude do objeto properties
                var markerLatLng = L.latLng(properties.latitude, properties.longitude);
                // Adiciona um novo marcador na latitude e longitude especificadas
                currentMarker = L.marker(markerLatLng).addTo(map);

                leafletImage(map, function (err, canvas) {
                    if (err) {
                        console.error('Erro ao capturar imagem do mapa:', err);
                        return;
                    }
                    // Remove o marcador depois que a imagem for capturada
                    map.removeLayer(currentMarker);
                    currentMarker = null;

                    toDataURL('brasao_Jequie.png', function (logo) {
                        // Cria uma nova janela para o modelo PDF
                        var pdfWindow = window.open('', '_blank');
                        pdfWindow.document.write('<html><head><title>PDF Template</title></head><body></body></html>');
                        // Carrega o modelo HTML na nova janela
                        fetch('./app/resources/pdf_template_imobiliario.html')
                            .then(response => response.text())
                            .then(template => {
                                pdfWindow.document.body.innerHTML = template;
                                // Atualizar elementos do template com dados
                                const setElementText = (selector, text) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.textContent = text || 'N/A';
                                };
                                const setElementSrc = (selector, src) => {
                                    const element = pdfWindow.document.querySelector(selector);
                                    if (element) element.src = src;
                                };

                                setElementSrc('#logo', logo);
                                setElementText('#properties\\.name', properties.name);
                                setElementText('#inscricao', inscricao);
                                setElementText('#data\\.imobiliario\\.matricula', data.imobiliario?.matricula);
                                setElementText('#data\\.codigo', data.codigo);
                                setElementText('#data\\.imobiliario\\.distrito', data.imobiliario?.distrito);
                                setElementText('#data\\.imobiliario\\.setor', data.imobiliario?.setor);
                                setElementText('#data\\.imobiliario\\.quadra', data.imobiliario?.quadra);
                                setElementText('#data\\.imobiliario\\.lote', data.imobiliario?.lote);
                                setElementText('#data\\.imobiliario\\.unidade', data.imobiliario?.unidade);
                                setElementText('#data\\.imobiliario\\.situacao\\.descricao',
                                    data.imobiliario.situacao.descricao || 'Estado desconhecido');
                                    function formatarDataBrasileira(dataISO) {
                                        if (!dataISO) return 'N/A';
                                        const data = new Date(dataISO);
                                        const dia = String(data.getDate()).padStart(2, '0');
                                        const mes = String(data.getMonth() + 1).padStart(2, '0');
                                        const ano = data.getFullYear();
                                        return `${dia}/${mes}/${ano}`;
                                      }
                                      
                                      const dataCadastro = formatarDataBrasileira(data?.dataInclusao);
                                      
                                      setElementText('#data\\.dataInclusao', dataCadastro);
                                setElementText('#data\\.logradouro\\.nome', data.logradouro?.nome);
                                setElementText('#data\\.numero', data.numero);
                                setElementText('#data\\.imobiliario\\.complemento', data.imobiliario?.complemento);
                                setElementText('#data\\.bairro\\.nome', data.bairro?.nome);
                                setElementText('#data\\.cidade\\.nome', data.cidade?.nome);
                                setElementText('#data\\.cidade\\.tipo\\.sigla', data.cidade.tipo.sigla);
                                setElementText('#data\\.cep', data.cep);
                                const campo9005 = data.imobiliario?.boletim?.find(b => b.campo === "9005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9005\\]\\.resposta\\.descricao', campo9005);
                                const campo9001 = data.imobiliario?.boletim?.find(b => b.campo === "9001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9001\\]\\.resposta\\.descricao', campo9001);
                                const campo9002 = data.imobiliario?.boletim?.find(b => b.campo === "9002")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[9002\\]\\.resposta\\.descricao', campo9002);
                                const campo1001 = data.imobiliario?.boletim?.find(b => b.campo === "1001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1001\\]\\.resposta\\.descricao', campo1001);
                                const campo1003 = data.imobiliario?.boletim?.find(b => b.campo === "1003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[1003\\]\\.resposta\\.descricao', campo1003);
                                const campo2001 = data.imobiliario?.boletim?.find(b => b.campo === "2001")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2001\\]\\.resposta\\.descricao', campo2001);
                                const campo2004 = data.imobiliario?.boletim?.find(b => b.campo === "2004")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2004\\]\\.resposta\\.descricao', campo2004);
                                const campo2006 = data.imobiliario?.boletim?.find(b => b.campo === "2006")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2006\\]\\.resposta\\.descricao', campo2006);
                                const campo2003 = data.imobiliario?.boletim?.find(b => b.campo === "2003")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2003\\]\\.resposta\\.descricao', campo2003);
                                const campo2005 = data.imobiliario?.boletim?.find(b => b.campo === "2005")?.resposta?.descricao || 'N/A';
                                setElementText('#data\\.imobiliario\\.boletim\\.campo\\[2005\\]\\.resposta\\.descricao', campo2005);

                                var mapImage = canvas.toDataURL('image/png');
                                pdfWindow.document.getElementById('mapImage').src = mapImage;
                                // Gera PDF a partir do conteúdo na janela usando html2canvas e jsPDF
                                setTimeout(() => {
                                    html2canvas(pdfWindow.document.body).then(canvas => {
                                        const { jsPDF } = window.jspdf;
                                        const doc = new jsPDF();
                                        const imgData = canvas.toDataURL('image/png');
                                        const imgProps = doc.getImageProperties(imgData);
                                        const pdfWidth = doc.internal.pageSize.getWidth();
                                        const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                        doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                        // Ocultar o loading após gerar o PDF
                                        document.getElementById('loading').style.display = 'none';
                                    });
                                }, 1000);
                            })
                            .catch(error => console.error('Erro ao carregar template:', error));
                    });
                });
            });
        },
        error: function (jqXHR, textStatus, errorThrown) {
            console.error('Erro ao buscar dados:', textStatus, errorThrown);
        }
    });
    // Converte imagem em base64
    function toDataURL(url, callback) {
        var xhr = new XMLHttpRequest();
        xhr.onload = function () {
            var reader = new FileReader();
            reader.onloadend = function () {
                callback(reader.result);
            };
            reader.readAsDataURL(xhr.response);
        };
        xhr.open('GET', url);
        xhr.responseType = 'blob';
        xhr.send();
    }
    // Constroi contentOther de geoJsonLayer
    contentOther += '<div class="row small text-center table-container">' +
        '<div class="col-md-12">' +
        '<div class="table-responsive">' +
        '<table class="table table-bordered table-hover table-sm table-sidebar">' +
        '<thead class="thead-dark">' +
        '<tr><th colspan="2" class="text-center text-custom-color">📌 Parâmetros de Uso e Ocupação</th>' +
        '</thead>' +
        '<tbody>' +
        '<tr><td class="text-left"><strong>Proprietário</strong></td><td class="text-left text-custom-color">' + (properties.name || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Inscrição</strong></td><td class="text-left text-custom-color">' + inscricao + '</td></tr>' +
        '<tr><td class="text-left"><strong>Utilização</strong></td><td class="text-left text-custom-color">' + (properties.utilizacao || "N/A") + '</td></tr>' +
        '<tr><td class="text-left"><strong>Zoneamento</strong></td><td class="text-left text-custom-color" id="zoneamentoValue2">' + (properties.zoneamento || "N/A") + '</td></tr>' +
        '</tbody>' +
        '</table>' +
        '</div>' +
        '<div class="col-md-12" id="cnaeFieldsContainer" style="margin-top: 10px;">' +
        '<div class="cnae-field">' +
        '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
        '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
        '<div class="cnaeResult"></div>' +
        '</div>' +
        '</div>' +
        '<div class="col-md-12" style="margin-top: 10px;">' +
        '<button id="addCNAEButton"><i class="fas fa-plus"></i> Adicionar CNAE</button>' +
        '</div>' +
        '<div class="col-md-12 text-center" style="margin-top: 10px;">' +
        '<button class="tablinks" id="generatePDF">' +
        '<i class="fas fa-file-pdf"></i> Consulta' +
        ' </button> ' +
        '</div>' +
        '</div>' +
        '</div>';
    // Função para anexar ouvintes de eventos
    function attachEventListeners() {
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
    // Função para pesquisar CNAE
    function pesquisarCNAE(button) {
        var cnaeInput = button.previousElementSibling;
        var cnae = cnaeInput.value;
        var zonaElement = document.getElementById('zoneamentoValue2');
        if (!zonaElement) {
            alert('O elemento de zoneamento não foi encontrado.');
            return;
        }

        var zona = zonaElement.textContent;
        if (!cnae || !zona) {
            alert('Por favor, preencha o CNAE e a zona.');
            return;
        }

        fetch('check_cnae.php?cnae=' + cnae + '&zoneamento=' + zona)
            .then(response => response.json())
            .then(data => {
                var cnaeResult = button.nextElementSibling;
                cnaeResult.innerHTML = '';

                if (data.error) {
                    cnaeResult.innerHTML = `<span style="color: red;">${data.error}</span>`;
                } else {
                    let icon = data.existe
                        ? '<i class="fas fa-check-circle" style="color: green;"></i> PERMITIDO'
                        : '<i class="fas fa-times-circle" style="color: red;"></i> NÃO PERMITIDO';

                    let grauRiscoText = `<br><strong>Grau de Risco:</strong> ${data.grau_risco || 'N/A'}`;

                    cnaeResult.innerHTML = `${icon} - ${data.descricao} ${grauRiscoText}`;
                }
            })
            .catch(error => console.error('Erro:', error));
    }
    // Função para adicionar um novo CNAE campo
    function adicionarCNAEField() {
        var container = document.getElementById('cnaeFieldsContainer');
        var newField = document.createElement('div');
        newField.className = 'cnae-field';
        newField.innerHTML =
            '<input type="text" class="cnaeInput" placeholder="Digite o CNAE">' +
            '<button class="pesquisarCNAEButton"><i class="fas fa-search"></i></button>' +
            '<div class="cnaeResult"></div>';

        container.appendChild(newField);

        newField.querySelector('.pesquisarCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            pesquisarCNAE(this);
        });
    }
    // Abra o painel lateral com o botão content
    openNav(contentInfo, contentOther);
    // Simule um clique na guia "Info" para abri-la por padrão
    document.getElementsByClassName('tablinks')[0].click();
    // anexar ouvintes de eventos aos botões CNAE e ao botão "Consulta"
    attachEventListeners();

    var currentMarker = null;

    document.getElementById('generatePDF').addEventListener('click', function (event) {
        event.preventDefault();
        // Exibir animação de carregamento
        document.getElementById('loading').style.display = 'flex';
        // Verifica se já existe um marcador, em caso afirmativo, remova-o
        if (currentMarker) {
            map.removeLayer(currentMarker);
        }
        // Usar a latitude e a longitude do objeto properties
        var markerLatLng = L.latLng(properties.latitude, properties.longitude);
        // Adicionar um novo marcador na latitude e longitude especificadas
        currentMarker = L.marker(markerLatLng).addTo(map);

        leafletImage(map, function (err, canvas) {
            if (err) {
                console.error('Erro ao capturar imagem do mapa:', err);
                return;
            }
            // Remova o marcador depois que a imagem for capturada
            map.removeLayer(currentMarker);
            currentMarker = null;

            toDataURL('brasao_Jequie.png', function (logo) {
                // criar uma nova janela para o modelo PDF
                var pdfWindow = window.open('', '_blank');
                pdfWindow.document.write('<html><head><title>Uso e Ocupação do Solo</title></head><body></body></html>');
                // Carregue o modelo HTML na nova janela
                fetch('./app/resources/pdf_template.html')
                    .then(response => response.text())
                    .then(template => {
                        pdfWindow.document.body.innerHTML = template;
                        // Acesse e atualize elementos com segurança
                        const logoElement = pdfWindow.document.getElementById('logo');
                        if (logoElement) {
                            logoElement.src = logo;
                        }
                        const nameElement = pdfWindow.document.getElementById('properties.name');
                        if (nameElement) {
                            nameElement.textContent = properties.name;
                        }
                        const inscricaoElement = pdfWindow.document.getElementById('inscricao');
                        if (inscricaoElement) {
                            inscricaoElement.textContent = inscricao;
                        }
                        const zoneamentoElement = pdfWindow.document.getElementById('properties.zoneamento');
                        if (zoneamentoElement) {
                            zoneamentoElement.textContent = properties.zoneamento;
                        }
                        const bairroElement = pdfWindow.document.getElementById('properties.bairro');
                        if (bairroElement) {
                            bairroElement.textContent = properties.bairro;
                        }
                        const logradouroElement = pdfWindow.document.getElementById('properties.logradouro');
                        if (logradouroElement) {
                            logradouroElement.textContent = properties.logradouro;
                        }
                        const numero_lotElement = pdfWindow.document.getElementById('properties.numero_lot');
                        if (numero_lotElement) {
                            numero_lotElement.textContent = properties.numero_lot;
                        }
                        const quadraElement = pdfWindow.document.getElementById('properties.quadra');
                        if (quadraElement) {
                            quadraElement.textContent = properties.quadra;
                        }
                        const loteElement = pdfWindow.document.getElementById('properties.lote');
                        if (loteElement) {
                            loteElement.textContent = properties.lote;
                        }

                        var cnaeFields = document.querySelectorAll('.cnae-field');
                        var cnaeResults = pdfWindow.document.getElementById('cnaeResults');

                        cnaeFields.forEach(field => {
                            var cnaeInput = field.querySelector('.cnaeInput').value;
                            var cnaeFullText = field.querySelector('.cnaeResult').textContent.trim();
                            // Ajuste na extração do resultado e grau de risco
                            var resultadoMatch = cnaeFullText.match(/(PERMITIDO|NÃO PERMITIDO)\s*-\s*(.+?)(?=\s*Grau de Risco|$)/);
                            var grauRiscoMatch = cnaeFullText.match(/Grau de Risco:\s*(.+)/);

                            var resultadoTexto = resultadoMatch
                                ? resultadoMatch[1] + (resultadoMatch[2] && resultadoMatch[2] !== "undefined" ? " - " + resultadoMatch[2].trim() : "")
                                : "N/A";
                            var grauRisco = grauRiscoMatch ? grauRiscoMatch[1] : "N/A";
                            // Criar a linha da tabela
                            var row = pdfWindow.document.createElement('tr');

                            var inputCell = pdfWindow.document.createElement('td');
                            inputCell.textContent = cnaeInput || "N/A";

                            var resultCell = pdfWindow.document.createElement('td');
                            resultCell.textContent = resultadoTexto;

                            var riscoCell = pdfWindow.document.createElement('td');
                            riscoCell.textContent = grauRisco;
                            // Aplicar classes de estilo corretamente
                            if (resultadoTexto.startsWith('NÃO PERMITIDO')) {
                                resultCell.classList.add('not-allowed'); // Vermelho para "NÃO PERMITIDO"
                            } else if (resultadoTexto.startsWith('PERMITIDO')) {
                                resultCell.classList.add('allowed'); // Verde para "PERMITIDO"
                            }
                            // Adicionar células à linha
                            row.appendChild(inputCell);
                            row.appendChild(resultCell);
                            row.appendChild(riscoCell);
                            // Adicionar a linha à tabela
                            cnaeResults.appendChild(row);
                        });

                        var mapImage = canvas.toDataURL('image/png');
                        pdfWindow.document.getElementById('mapImage').src = mapImage;
                        // Gere PDF a partir do conteúdo da nova janela usando html2canvas e jsPDF
                        setTimeout(() => {
                            html2canvas(pdfWindow.document.body).then(canvas => {
                                const { jsPDF } = window.jspdf;
                                const doc = new jsPDF();
                                const imgData = canvas.toDataURL('image/png');
                                const imgProps = doc.getImageProperties(imgData);
                                const pdfWidth = doc.internal.pageSize.getWidth();
                                const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;

                                doc.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
                                // Ocultar o loading após gerar o PDF
                                document.getElementById('loading').style.display = 'none';
                            });
                        }, 1000);
                    })
                    .catch(error => console.error('Erro ao carregar template:', error));
            });
        });
    });

    function attachEventListeners() {
        // Ouvinte de eventos de botões CNAE existente
        document.querySelectorAll('.pesquisarCNAEButton').forEach(function (button) {
            button.addEventListener('click', function (event) {
                event.preventDefault();
                pesquisarCNAE(this);
            });
        });

        document.getElementById('addCNAEButton').addEventListener('click', function (event) {
            event.preventDefault();
            adicionarCNAEField();
        });
    }
},
);

// ===== Medição de Área e Comprimento =====
var isMeasuring = false;
var measureControl = new L.Control.Measure({
    position: "topleft",
    primaryLengthUnit: "meters",
    secondaryLengthUnit: "kilometers",
    primaryAreaUnit: "sqmeters",
    secondaryAreaUnit: "hectares"
});

document.getElementById("MeasureArea").addEventListener("click", function (e) {
    e.preventDefault();
    isMeasuring = !isMeasuring;
    isMeasuring ? map.addControl(measureControl) : map.removeControl(measureControl);
    this.classList.toggle("selected");
});

// ===== Minha Localização =====
(function () {
    let userLocationMarker = null;
    document.getElementById('widgetUserLocation').addEventListener('click', function () {
        toggleUserLocation();
        this.classList.toggle('selected');
    });
    function toggleUserLocation() {
        if (userLocationMarker) {
            map.removeLayer(userLocationMarker);
            userLocationMarker = null;
        } else {
            navigator.geolocation.getCurrentPosition(
                function (position) {
                    const userLatLng = L.latLng(position.coords.latitude, position.coords.longitude);
                    userLocationMarker = L.marker(userLatLng).addTo(map).bindPopup("Você está aqui!").openPopup();
                    map.setView(userLatLng, 15);
                },
                function (error) {
                    alert("Não foi possível acessar sua localização: " + error.message);
                }
            );
        }
    }
})();

// ===== Pesquisar Inscrição e Nome =====
var searchControl = new L.Control.Search({
    layer: wfsLayer,
    zoom: 20,
    collapsed: false, // Mantém visível
    position: 'topleft',
    initial: false,
    hideMarkerOnCollapse: true,
    propertyName: 'inscricao',
    filterData: customPropertySearch,
    moveToLocation: (latlng, title, map) => map.setView(latlng, 20)
}).addTo(map);

// Função para filtrar busca por Inscrição e Nome
function customPropertySearch(text) {
    var filteredData = {};
    var normalizedText = text.trim().toLowerCase();
    wfsLayer.eachLayer(layer => {
        var props = layer.feature.properties;
        var inscricao = props.inscricao?.toString().toLowerCase() || '';
        var name = props.name?.toString().toLowerCase() || '';
        if (inscricao.includes(normalizedText) || name.includes(normalizedText)) {
            filteredData[props.inscricao || props.name] = layer;
        }
    });
    return filteredData;
}

// Mover os campos de busca para a barra superior
document.getElementById('search-control-container').appendChild(document.querySelector('.leaflet-control-search')); // Move a busca por inscrição e nome

// Impedir que o Enter faça o mapa descer
document.querySelectorAll('.leaflet-control input').forEach(input => {
    input.addEventListener('keydown', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault(); // Bloqueia o Enter
        }
    });
});

/*
// ===== Criar botão de microfone =====
var micButton = document.createElement("button");
micButton.id = "btnVoice"; // Adiciona um ID
micButton.innerHTML = "🎤";
micButton.style.position = "absolute";
micButton.style.right = "5px";
micButton.style.top = "5px";
micButton.style.border = "none";
micButton.style.background = "transparent";
micButton.style.cursor = "pointer";
micButton.style.fontSize = "20px";
micButton.style.opacity = "0.7";

// Adicionar botão ao campo de pesquisa
var searchInput = document.querySelector(".leaflet-control-search .search-input");
searchInput.parentElement.appendChild(micButton);

// ===== API de Reconhecimento de Voz =====
document.getElementById("btnVoice").addEventListener("click", function () {
    var recognition = new (window.SpeechRecognition || window.webkitSpeechRecognition)();
    recognition.lang = "pt-BR"; // Define idioma para português do Brasil
    recognition.start();

    recognition.onresult = function (event) {
        var recognizedText = event.results[0][0].transcript;
        console.log("Texto reconhecido:", recognizedText);
        
        // Preenche o campo de busca com o texto reconhecido
        document.querySelector(".leaflet-control-search .search-input").value = recognizedText;

        // Simula clique no botão de pesquisa
        document.querySelector(".leaflet-control-search .search-button").click();
    };

    recognition.onerror = function (event) {
        console.error("Erro no reconhecimento de voz:", event.error);
    };
});

// Verificar suporte à API de reconhecimento de voz
if (!('webkitSpeechRecognition' in window) && !('SpeechRecognition' in window)) {
    console.log("Seu navegador não suporta a API de reconhecimento de voz.");
} else {
    console.log("API de reconhecimento de voz suportada.");
}
    */

// ===== Pesquisar Endereço =====
var osmGeocoder = new L.Control.Geocoder({
    collapsed: false,
    position: 'topright',
    text: 'Search',
    title: 'Testing',
}).addTo(map);

// ===== Desenhar Polígono =====
var styleEditor;
var styleEditorActive = false; // Controle do estado do StyleEditor
// Evento para ativar/desativar o StyleEditor
document.getElementById('widgetStyleEditor').addEventListener('click', function () {
    var button = this; // Referência ao botão
    if (styleEditorActive) {
        // Remove o StyleEditor do mapa
        if (styleEditor) {
            map.removeControl(styleEditor);
            styleEditor = null; // Redefine a variável
        }
        styleEditorActive = false;
        button.src = "vendor/geojequie/css/images/designer-grafico_ok.png"; // Ícone para indicar desativado
        button.classList.remove('selected'); // Remove o contorno
    } else {
        // Adiciona o StyleEditor ao mapa
        styleEditor = L.control.styleEditor({
            position: 'topleft',
        }).addTo(map);
        styleEditorActive = true;
        button.src = "vendor/geojequie/css/images/designer-grafico_ok.png"; // Ícone para indicar ativado
        button.classList.add('selected'); // Adiciona o contorno
    }
});
// Variável para rastrear o estado da medição
var isMeasuring = false;
// Adiciona o featureGroup para armazenar os polígonos desenhados e marcadores
var drawnItems = new L.FeatureGroup();
map.addLayer(drawnItems);
// Inicializa o controle de desenho, mas sem adicionar ao mapa ainda
var drawControl = new L.Control.Draw({
    draw: {
        polygon: {
            shapeOptions: {
                stroke: true,
                color: 'black',       // Cor da linha do polígono
                fillColor: 'yellow',  // Cor de preenchimento do polígono
                weight: 2             // Largura da borda
            },
            showArea: true  // Mostrar área automaticamente
        },
        polyline: true,
        rectangle: false,
        circle: false,
        marker: true,
        circlemarker: false
    },
    edit: {
        featureGroup: drawnItems,  // Permite editar os polígonos desenhados e marcadores
        remove: true  // Permite deletar os objetos
    }
});
// Função para alternar a ferramenta de medição ao clicar no ícone
document.getElementById('widgetMeasureArea').addEventListener('click', function (e) {
    e.preventDefault();

    if (isMeasuring) {
        // Desativa o modo de desenho ao remover o controle de medição
        map.removeControl(drawControl);
        isMeasuring = false;
        document.getElementById("widgetMeasureArea").src = "vendor/geojequie/css/images/escrevendo.png";
        // Remove a classe .selected do ícone
        document.getElementById("widgetMeasureArea").classList.remove("selected");
    } else {
        // Ativa o modo de desenho ao adicionar o controle de medição
        map.addControl(drawControl);
        isMeasuring = true;
        document.getElementById("widgetMeasureArea").src = "vendor/geojequie/css/images/escrevendo.png";
        // Adiciona a classe .selected ao ícone
        document.getElementById("widgetMeasureArea").classList.add("selected");
    }
});
// Captura o evento de criação de um polígono ou marcador e adiciona-o ao mapa
map.on('draw:created', function (e) {
    var type = e.layerType,
        layer = e.layer;
    // Adiciona o objeto desenhado (polígono ou marcador) ao featureGroup
    drawnItems.addLayer(layer);
    // Exibe um log no console para ajudar no desenvolvimento
    if (type === 'marker') {
        console.log('Marcador adicionado: ', layer.getLatLng());
    } else if (type === 'polygon') {
        console.log('Polígono adicionado: ', layer);
    }
});
// Captura o evento de edição de objetos
map.on('draw:edited', function (e) {
    var layers = e.layers;
    layers.eachLayer(function (layer) {
        console.log('Objeto editado:', layer);
    });
});
// Captura o evento de exclusão de objetos
map.on('draw:deleted', function (e) {
    var layers = e.layers;
    layers.eachLayer(function (layer) {
        console.log('Objeto deletado:', layer);
    });
});

// ===== Traçar Rota =====
(function () {
    let isRoutingActive = false; // Controla se o modo "Traçar Rota" está ativo
    let destinationLatLng = null; // Variável global para armazenar o destino selecionado
    let routingControl = null; // Controle de rota
    let watchId = null; // ID para o rastreamento da localização em tempo real
    const recalculationThreshold = 50; // Distância em metros para recalcular a rota

    // Evento para o botão "Traçar Rota"
    document.getElementById('widgetRoute').addEventListener('click', function () {
        isRoutingActive = !isRoutingActive; // Toggle the routing mode
        if (isRoutingActive) {
            alert('Clique no mapa para selecionar um destino.');
        } else {
            alert('Modo "Traçar Rota" desativado.');
            stopTracking(); // Para de rastrear a localização
        }
    });

    // Evento para selecionar o destino ao clicar no mapa
    map.on('click', function (e) {
        if (!isRoutingActive) return; // Só executa se o modo "Traçar Rota" estiver ativo

        destinationLatLng = e.latlng; // Atribui o local clicado à variável global
        if (confirm('Destino selecionado: ' + destinationLatLng.lat + ', ' + destinationLatLng.lng + '. Criar rota?')) {
            traceRouteToMarker(destinationLatLng); // Cria a rota automaticamente
            isRoutingActive = false; // Desativa o modo "Traçar Rota" após criar a rota
        }
    });

    // Função para traçar rota
    function traceRouteToMarker(markerLatLng) {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(function (position) {
                const userLatLng = L.latLng(position.coords.latitude, position.coords.longitude);

                // Remove a rota existente, se houver
                if (routingControl) {
                    map.removeControl(routingControl);
                }

                // Adiciona o controle de rota ao mapa
                routingControl = L.Routing.control({
                    waypoints: [
                        userLatLng, // Ponto inicial: localização do usuário
                        markerLatLng // Ponto final: posição do marcador
                    ],
                    routeWhileDragging: false,
                    geocoder: L.Control.Geocoder.nominatim(),
                    language: 'pt-BR'
                }).addTo(map);

                // Começa a rastrear a localização
                startTracking(markerLatLng);

                // Adicionar o botão de fechar rota
                addCloseRouteButton();

            }, function (error) {
                alert('Erro ao obter localização: ' + error.message);
            });
        } else {
            alert('Geolocalização não é suportada neste navegador.');
        }
    }

    // Rastreia a localização do usuário e atualiza a rota em tempo real
    function startTracking(markerLatLng) {
        if (navigator.geolocation) {
            watchId = navigator.geolocation.watchPosition(function (position) {
                const userLatLng = L.latLng(position.coords.latitude, position.coords.longitude);

                // Verifica se a distância do trajeto é maior que o limite
                if (routingControl) {
                    const currentWaypoint = routingControl.getWaypoints()[0].latLng;
                    const distance = map.distance(userLatLng, currentWaypoint);

                    if (distance > recalculationThreshold) {
                        console.log('Recalculando rota devido a desvio...');
                        routingControl.setWaypoints([userLatLng, markerLatLng]);
                    }
                }
            }, function (error) {
                alert('Erro ao rastrear localização: ' + error.message);
            }, {
                enableHighAccuracy: true, // Maior precisão
                maximumAge: 0,
                timeout: 5000
            });
        } else {
            alert('Geolocalização não é suportada neste navegador.');
        }
    }

    // Para o rastreamento de localização
    function stopTracking() {
        if (watchId !== null) {
            navigator.geolocation.clearWatch(watchId); // Para de monitorar a localização
            watchId = null;
        }

        if (routingControl) {
            map.removeControl(routingControl); // Remove o controle de rota
            routingControl = null;
        }

        // Remove o botão de fechar rota, se existir
        const existingButton = document.querySelector('.close-route-button-container');
        if (existingButton) {
            existingButton.remove();
        }
    }

    // Adiciona botão para fechar a rota
    function addCloseRouteButton() {
        // Verifica se o botão já existe
        const existingButton = document.querySelector('.close-route-button-container');
        if (existingButton) {
            existingButton.remove();
        }

        const closeButton = L.control({ position: 'topright' });

        closeButton.onAdd = function () {
            const div = L.DomUtil.create('div', 'close-route-button-container');
            div.innerHTML = `<button class="close-route-button">X</button>`;
            div.style.zIndex = 1000; // Garante que o botão fique acima de outros elementos

            div.onclick = function () {
                stopTracking(); // Para o rastreamento e remove o controle de rota
                map.removeControl(closeButton); // Remove o botão
            };

            return div;
        };

        closeButton.addTo(map); // Adiciona o botão ao mapa
        console.log('Botão de fechar rota adicionado ao mapa.');
    }
})();

// ===== PrintMap =====
document.getElementById('widgetPrintMap').addEventListener('click', function (e) {
    e.preventDefault();
    // Exibir animação de carregamento
    document.getElementById('loading').style.display = 'flex';

    leafletImage(map, function (err, canvas) {
        if (err) {
            console.error('Erro ao capturar imagem do mapa:', err);
            // Ocultar o loading em caso de erro
            document.getElementById('loading').style.display = 'none';
            return;
        }

        var ctx = canvas.getContext('2d');
        // Função para desenhar polígonos e polilinhas
        function drawLatLngs(ctx, latlngs) {
            var pixelPoints = latlngs.map(function (latlng) {
                var point = map.latLngToContainerPoint(latlng);
                return [point.x, point.y];
            });

            ctx.beginPath();
            pixelPoints.forEach(function (point, index) {
                if (index === 0) {
                    ctx.moveTo(point[0], point[1]);
                } else {
                    ctx.lineTo(point[0], point[1]);
                }
            });
            ctx.closePath();
            ctx.stroke();
        }
        // Processar os itens desenhados
        drawnItems.eachLayer(function (layer) {
            ctx.strokeStyle = layer.options.color || 'black';
            ctx.fillStyle = 'rgba(0, 0, 0, 0)'; // Transparente
            ctx.lineWidth = layer.options.weight || 2;

            if (layer instanceof L.Polygon || layer instanceof L.Polyline) {
                var latlngs = layer.getLatLngs();
                if (Array.isArray(latlngs[0])) {
                    latlngs.forEach(function (subLatLngs) {
                        drawLatLngs(ctx, subLatLngs);
                    });
                } else {
                    drawLatLngs(ctx, latlngs);
                }
            } else if (layer instanceof L.Rectangle) {
                var bounds = layer.getBounds();
                var topLeft = map.latLngToContainerPoint(bounds.getNorthWest());
                var bottomRight = map.latLngToContainerPoint(bounds.getSouthEast());

                ctx.beginPath();
                ctx.rect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
                ctx.stroke();
            } else if (layer instanceof L.Circle) {
                var center = map.latLngToContainerPoint(layer.getLatLng());
                // Ajustar o cálculo do raio para ser proporcional ao zoom
                var radiusInPixels = map.latLngToContainerPoint(layer.getLatLng())
                    .distanceTo(map.latLngToContainerPoint([layer.getLatLng().lat, layer.getLatLng().lng + layer.getRadius() / 40075017 * 360]));

                ctx.beginPath();
                ctx.arc(center.x, center.y, radiusInPixels, 0, 2 * Math.PI);
                ctx.stroke();
            } else if (layer instanceof L.CircleMarker) {
                var center = map.latLngToContainerPoint(layer.getLatLng());
                var radius = layer.getRadius();

                ctx.beginPath();
                ctx.arc(center.x, center.y, radius, 0, 2 * Math.PI);
                ctx.stroke();
            }
        });
        // Converter o canvas atualizado para uma imagem
        var imgData = canvas.toDataURL('image/png');
        // Ocultar o loading após o canvas ser processado
        document.getElementById('loading').style.display = 'none';
        // Abrir uma nova janela para imprimir o mapa
        var printWindow = window.open('', '_blank');

        printWindow.document.write('<html><head><title>Imprimir Mapa</title></head><body>');
        printWindow.document.write('<img src="' + imgData + '" style="width: 100%; height: auto;">');
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        // Acionar o diálogo de impressão
        setTimeout(function () {
            printWindow.print();
        }, 500);
    });
});