<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{title}}</title>
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet.css">
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet.draw.css">
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet-measure.css" />
    <link rel="stylesheet" href="vendor/geojequie/css/L.Control.ZoomBar.css" />
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet-control-geocoder.Geocoder.css">
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet-search.css">
    <link rel="stylesheet" href="vendor/geojequie/css/cortinalateral.css">
    <link rel="stylesheet" href="vendor/geojequie/css/Leaflet.StyleEditor.min.css">
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet.groupedlayercontrol.css" />
    <link rel="stylesheet" href="vendor/geojequie/css/all.min.css">
    <!-- Adicione o CSS do Leaflet Routing Machine -->
    <link rel="stylesheet" href="vendor/geojequie/css/leaflet-routing-machine.css">

    <script src="vendor/geojequie/js/leaflet.js"></script>
    <script src="vendor/geojequie/js/leaflet.draw.js"></script>
    <script src="vendor/geojequie/js/editable.js"></script>
    <script src="vendor/geojequie/js/leaflet-measure.js"></script>
    <script src="vendor/geojequie/js/L.Control.ZoomBar.js"></script>
    <script src="vendor/geojequie/js/StreetViewButtons.js"></script>
    <script src="vendor/geojequie/js/leaflet-control-geocoder.Geocoder.js"></script>
    <script src="vendor/geojequie/js/leaflet-search.js"></script>
    <script src="vendor/geojequie/js/Leaflet.StyleEditor.min.js"></script>
    <script src="vendor/geojequie/js/leaflet.groupedlayercontrol.js"></script>
    <script src="vendor/geojequie/js/bundle.js"></script>
    <script src="https://rawgit.com/mapbox/leaflet-image/gh-pages/leaflet-image.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.21/jspdf.plugin.autotable.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/leaflet-image/0.2.4/leaflet-image.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Turf.js/5.1.6/turf.min.js"></script>
    <script
        src="https://cdnjs.cloudflare.com/ajax/libs/leaflet-routing-machine/3.2.12/leaflet-routing-machine.min.js"></script>

    <style>
        #map {
            height: 76vh;
            width: 100%;
            z-index: 1;
        }
        #map_coords {
            margin-top: 10px;
        }
        .leaflet-top.leaflet-left {
            z-index: 1000;
        }

        #loading {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        .loading-animation {
            position: relative;
            width: 100px;
            height: 120px;
            /* Ajuste para incluir o texto */
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .loading-animation img {
            width: 70%;
            height: auto;
            animation: rotateAnimation 0.0s linear infinite;
        }

        .loading-animation p {
            margin-top: 10px;
            font-size: 14px;
            font-weight: bold;
            color: #333;
            /* Ajuste a cor conforme necessário */
        }

        @keyframes rotateAnimation {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }

        .result-icon {
            font-size: 24px;
            display: none;
            margin-left: 10px;
        }

        .result-icon.success {
            color: green;
        }

        .result-icon.error {
            color: red;
        }

        .cnaeInput {
            margin-right: 10px;
        }

        .pesquisarCNAEButton {
            cursor: pointer;
            width: 30px;
            height: 26px;
            font-size: 14px;
        }

        .pesquisarCNAEButton i {
            font-size: 14px;
        }

        .allowed {
            background-color: green;
            color: white;
        }

        .not-allowed {
            background-color: red;
            color: white;
        }

        /* Nova regra CSS para o tamanho da fonte nav-tabs */
        .nav-tabs>li>a {
            font-size: 12px;
            /* Defina o tamanho da fonte como 12px */
        }

        .text-custom-color {
            color: #B8C7CE;
        }

        .top-bar {
            display: flex;
            justify-content: left;
            /* Centralizar os ícones horizontalmente */
            background-color: #1D2D53;
            padding: 0;
            /* Reduz o padding para aproximar os ícones do topo */
            border-bottom: 0 solid #63828a;
            position: relative;
            /* Permite manipular a posição com top */
            top: 0px;
            /* Sobe a barra um pouco */
        }

        .top-bar img {
            cursor: pointer;
            width: 28px;
            height: 28px;
            margin: 0 25px;
            /* Reduz o espaçamento horizontal entre os ícones */
        }

        .selected {
            border: 2px solid #007BFF;
            /* Cor azul para destacar o botão */
            border-radius: 5px;
            /* Bordas arredondadas */
            box-shadow: 0 0 10px rgba(0, 123, 255, 0.5);
            /* Efeito de sombra */
        }

        .polygon-label {
            color: orangered;
            font-size: 12px;
            font-weight: bold;
            text-align: center;
            text-shadow: -1px -1px 0 white, 1px -1px 0 white, -1px 1px 0 white, 1px 1px 0 white;
            background-color: rgba(255, 255, 255, 0);
            /* Fundo transparente */
            border: none;
            /* Remove bordas padrão */
            padding: 2px;
        }

        #sidebarcadastro {
            width: 25%;
            height: 100%;
            background-color: #f4f4f4;
            padding: 10px;
            display: none;
            /* Inicialmente oculto */
            overflow-y: auto;
            position: absolute;
            right: 0;
            top: 0;
            z-index: 2;
            transition: width 0.3s ease;
            /* Animação para mudanças de largura */
        }

        .sidebarcadastro-content input[type="text"] {
            width: 100%;
            /* Faz os campos ocuparem toda a largura */
            padding: 10px;
            /* Adiciona espaço interno */
            margin-bottom: 10px;
            /* Espaço entre os campos */
            box-sizing: border-box;
            /* Garante que o padding não aumente a largura total */
            border: 1px solid #ccc;
            /* Adiciona uma borda leve */
            border-radius: 4px;
            /* Arredonda os cantos */
            font-size: 16px;
            /* Aumenta o tamanho da fonte para melhor legibilidade */
        }

        /* Responsividade */
        @media (max-width: 1024px) {
            #sidebarcadastro {
                width: 35%;
                /* Aumenta a largura em telas menores */
            }

            #map {
                height: 100vh;
                /* Reduz a altura para telas médias */
            }
        }

        @media (max-width: 768px) {
            #sidebarcadastro {
                width: 60%;
                /* Metade da tela em dispositivos móveis */
            }

            #map {
                height: 100vh;
                /* Reduz mais a altura para telas menores */
            }
        }

        @media (max-width: 480px) {
            #sidebarcadastro {
                width: 100%;
                /* Sidebar ocupa toda a largura em telas muito pequenas */
                height: 60%;
                /* Ajusta a altura para não cobrir o mapa */
                bottom: 0;
                top: auto;
                /* Move a sidebar para a parte inferior da tela */
            }

            #map {
                height: 100vh;
                /* Em dispositivos muito pequenos, metade da tela */
            }
        }

        .sidebarcadastro-header {
            font-size: 20px;
            margin-bottom: 15px;
        }

        .sidebarcadastro-content {
            margin-bottom: 15px;
        }

        .close-btn {
            background-color: rgb(83, 71, 71);
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
            border-radius: 5px;
        }

        #saveBtn {
            background-color: rgb(83, 71, 71);
            color: white;
            padding: 10px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <!-- Barra loading -->
    <div id="loading" style="display: none;">
        <div class="loading-animation">
            <img src="vendor/geojequie/css/images/GPI-LOGO_2s.gif" alt="Loading Logo">
            <p>Aguarde...</p>
        </div>
    </div>
    <!-- Barra superior -->
    <div class="top-bar">
    <div id="search-container">
        <div id="search-control-container"></div>
    </div>
        <img src="vendor/geojequie/css/images/escrevendo.png" title="Desenhar sobre o mapa" id="widgetMeasureArea">
        <img src="vendor/geojequie/css/images/designer-grafico.png" title="Editor de Desenho " id="widgetStyleEditor">
        <img src="vendor/geojequie/css/images/rulers_@2X2.png" title="Medir Área" id="MeasureArea">
        <img src="vendor/geojequie/css/images/mapa-3d.png" title="Minha Localização" id="widgetUserLocation">
        
        <img src="vendor/geojequie/css/images/route.png" title="Traçar Rota" id="widgetRoute">
    </div>

    <!-- Sidebar -->
    <div id="sidePanel" class="sidepanel">
        <div class="tab">
            <button class="tablinks" onclick="openTab(event, 'Info')">
                <i class="fas fa-info-circle"></i> Imobiliário
            </button>
            <button class="tablinks" onclick="openTab(event, 'Other')">
                <i class="fas fa-map-marker-alt"></i> Viabilidade
            </button>
            <a href="#" class="close-btn" onclick="closeNav(); return false;">
                <i class="fa fa-times"></i>
            </a>
        </div>
        <div id="Info" class="tabcontent">
            <div id="panelContentInfo">
                <!-- O conteúdo da aba Info será preenchido aqui -->
            </div>
        </div>
        <div id="Other" class="tabcontent">
            <div id="panelContentOther">
                <!-- O conteúdo da aba Other será preenchido aqui -->
            </div>
        </div>
    </div>

    <div id="map"></div>
    <div id="map_coords" style="text-align: center; margin-top: 10px;"></div>

    <script src="vendor/geojequie/MapaFiscalJequie/mapa_fiscal_jequie_a.js"></script> <!-- Carrega o JavaScript externo -->

</body>
</html>
