<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$apiKey = '5b3ce3597851110001cf62481571ada3fcf8474cbbc0b12d2b05ec49';

// Verifica se veio um corpo com dados
$input = file_get_contents('php://input');
if (!$input) {
    http_response_code(400);
    echo json_encode(['error' => 'Nenhum dado recebido no corpo da requisição']);
    exit;
}

$data = json_decode($input, true);
if (!isset($data['coordinates'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Formato de dados inválido: faltam as coordenadas']);
    exit;
}

// Monta o corpo da requisição para OpenRouteService
$postData = [
    'coordinates' => $data['coordinates'],
    'language' => 'pt',
    'units' => 'km'
];

// Opcional: se quiser evitar instruções passo a passo
if (isset($data['instructions']) && $data['instructions'] === false) {
    $postData['instructions'] = false;
}

$url = 'https://api.openrouteservice.org/v2/directions/driving-car/geojson';

$options = [
    'http' => [
        'header'  => [
            "Content-type: application/json",
            "Authorization: $apiKey"
        ],
        'method'  => 'POST',
        'content' => json_encode($postData),
        'ignore_errors' => true
    ]
];

$context  = stream_context_create($options);
$response = file_get_contents($url, false, $context);

// Verifica erro da API
if ($response === FALSE) {
    http_response_code(500);
    echo json_encode(['error' => 'Erro ao consultar OpenRouteService']);
    exit;
}

// Retorna resposta da API para o navegador
header('Content-Type: application/json');
echo $response;
