function loadKanbanData() {
    fetch('index.php?class=TaskService&method=getTasks')
        .then(res => res.json())
        .then(tasks => {
            document.querySelectorAll('.task-list').forEach(e => e.innerHTML = '');

            tasks.forEach(task => {
                const el = document.createElement('div');
                el.className = 'kanban-task';
                el.draggable = true;
                el.textContent = task.title;
                el.dataset.id = task.id;

                el.addEventListener('dragstart', (e) => {
                    e.dataTransfer.setData('text/plain', task.id);
                });

                const container = document.querySelector(`.task-list[data-status="${task.status}"]`);
                if (container) container.appendChild(el);
            });
        });
}

document.addEventListener('DOMContentLoaded', () => {
    document.querySelectorAll('.task-list').forEach(list => {
        list.addEventListener('dragover', (e) => e.preventDefault());
        list.addEventListener('drop', (e) => {
            e.preventDefault();
            const id = e.dataTransfer.getData('text/plain');
            const newStatus = list.dataset.status;

            fetch(`index.php?class=TaskService&method=updateTaskStatus`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `id=${id}&status=${encodeURIComponent(newStatus)}`
            }).then(() => loadKanbanData());
        });
    });
});
