<?php
use Adianti\Database\TRecord;

class Bairro extends TRecord
{
    const TABLENAME  = 'comum.bairro';
    const PRIMARYKEY = 'id';
    const IDPOLICY   = 'serial';
    const DATABASE   = 'comum';

    public function get_municipio()
    {
        if (!empty($this->id_munic_local)) {
            return new MunicipioLocalidade($this->id_munic_local);
        }
        return null;
    }

    public function get_municipio_nome()
    {
        $m = $this->get_municipio();
        return $m ? $m->nome : null;
    }
}
