<?php
/**
 * Consulta_viabilidadeFormView
 *
 * @version    8.0
 * @package    control
 * @subpackage admin
 */
class Consulta_viabilidadeFormView extends TPage
{
    private $form;

    function __construct()
    {
        parent::__construct();
        parent::setTargetContainer('adianti_right_panel');

        // Cria o formulário antes de tudo
        $this->form = new BootstrapFormBuilder('form_enable_disable');

        // Campos
        $code       = new TEntry('code');
        $lote       = new TEntry('lote');
        $setor      = new TEntry('setor');
        $quadra     = new TEntry('quadra');
        $numero_lot = new TEntry('numero_lot');
        $logradouro = new TEntry('logradouro');
        $bairro     = new TEntry('bairro');
        $pessoa     = new TEntry('pessoa');

        foreach ([$code, $lote, $setor, $quadra, $numero_lot, $logradouro, $bairro, $pessoa] as $field) {
            $field->setSize('100%');
        }

        // Layout dos campos
        $this->form->addFields([ new TLabel('Inscrição'), $code ])->layout = ['col-sm-4', 'col-sm-8'];
        $this->form->addFields([ new TLabel('Setor'), $setor ], [ new TLabel('Quadra'), $quadra ])->layout = ['col-sm-4', 'col-sm-4'];
        $this->form->addFields([ new TLabel('Lote'), $lote ])->layout = ['col-sm-4', 'col-sm-4'];
        $this->form->addFields([ new TLabel('Número'), $numero_lot ], [ new TLabel('Logradouro'), $logradouro ])->layout = ['col-sm-4', 'col-sm-4'];
        $this->form->addFields([ new TLabel('Bairro'), $bairro ])->layout = ['col-sm-4', 'col-sm-4'];

        // Adiciona div para mapa
        $mapDiv = new TElement('div');
        $mapDiv->id = 'mapView';
        $mapDiv->style = 'width: 100%; height: 400px; border: 1px solid #ccc; border-radius: 6px; margin-top: 20px;';
        $this->form->addContent([$mapDiv]);

        $this->form->addAction('Fechar', new TAction([$this, 'onClose']), 'fa:times red');

        // Pega os parâmetros da URL
        $modo      = $_GET['modo'] ?? 'consulta';
        $inscricao = $_GET['inscricao'] ?? null;

        $formData = [];

        if ($inscricao) {
            $url = "https://sisprom-br.com.br:8443/geoserver/sisprom/wfs?service=WFS&version=2.0.0&request=GetFeature&typeNames=sisprom:Jequie_2025_postgis&outputFormat=application/json&srsName=EPSG:4674&CQL_FILTER=inscricao='$inscricao'";
            $json = $this->getUrlContent($url);
            $geojson = json_decode($json);

            if (isset($geojson->features[0])) {
                $props = $geojson->features[0]->properties;

                $formData = [
                    'code'       => $props->inscricao ?? '',
                    'lote'       => $props->lote ?? '',
                    'quadra'     => $props->quadra ?? '',
                    'setor'      => $props->setor ?? '',
                    'bairro'     => $props->bairro ?? '',
                    'numero_lot' => $props->numero_lot ?? '',
                    'logradouro' => $props->logradouro ?? '',
                    'pessoa'     => $props->pessoa ?? '',
                ];

                // Aplica dados ao formulário
                $this->form->setData((object) $formData);

                // Mostra ponto no mapa se houver coordenadas
                if (isset($props->latitude) && isset($props->longitude)) {
        $lat = floatval($props->latitude);
        $lng = floatval($props->longitude);

        // envia para função JS global que já está definida no seu código
        TScript::create("setMapPoint($lat, $lng);");
                }
            }
        }

        // Aplica modo consulta/edição
        self::setFormEditableByMode(['enable' => $modo]);

        // Exibe o formulário
        $vbox = new TVBox;
        $vbox->style = 'width: 100%';
        $vbox->add($this->form);
        parent::add($vbox);
    }

    public static function setFormEditableByMode($param)
    {
        $fields = ['code', 'lote', 'setor', 'quadra', 'pessoa', 'bairro', 'numero_lot', 'logradouro'];

        foreach ($fields as $field) {
            if ($param['enable'] == 'consulta') {
                TEntry::disableField('form_enable_disable', $field);
            } else {
                TEntry::enableField('form_enable_disable', $field);
            }
        }
    }

    private function getUrlContent($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    public function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }
}
