<?php
/**
 * Consulta_contribuinteFormView
 *
 * @version    8.0
 * @package    control
 * @subpackage admin
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class Consulta_contribuinteFormView extends TPage
{
    private $form;

    function __construct()
    {
        parent::__construct();

        parent::setTargetContainer('adianti_right_panel');

        // Pega o valor de "modo" da URL (default é 1 - Consulta)
        $modo = isset($_GET['modo']) ? $_GET['modo'] : 'consulta';

        // Cria o formulário
        $this->form = new BootstrapFormBuilder('form_enable_disable');

        // Campos do formulário        
        $cep = new TEntry('cep');
        $code = new TEntry('code');
        $lote = new TEntry('lote');
        $face = new TEntry('face');
        $setor = new TEntry('setor');
        $codigo = new TEntry('codigo');
        $pessoa = new TEntry('pessoa');
        $bairro = new TEntry('bairro');
        $numero = new TEntry('numero');
        $quadra = new TEntry('quadra');
        $unidade = new TEntry('unidade');  
        $distrito = new TEntry('distrito');
        $matricula = new TEntry('matricula');
        $logradouro = new TEntry('logradouro');
         
        // 9 - Medidas do Imóvel
        $fundo = new TEntry('fundo');
        $frente = new TEntry('frente');
        $arealote = new TEntry('arealote');
        $arealivre = new TEntry('arealivre');
        $numerounidades = new TEntry('numerounidades');
        $areaconstruida = new TEntry('areaconstruida');        
        
        
        function getUrlContent($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

// Buscar dados da API se houver inscrição
if (!empty($_GET['inscricao'])) {
    $inscricao = $_GET['inscricao'];
    $code->setValue($inscricao);

    // URL completa
    $url = "http://geojequie.sisprom-br.com.br/vendor/geojequie/consulta_inscricao_el.php?inscricao=" . urlencode($inscricao);
    $response = getUrlContent($url);

    if ($response) {
        $data = json_decode($response, true);
        
        if ($data) {
                    $codigo->setValue($data['codigo'] ?? 'N/A');
                    $matricula->setValue($data['imobiliario']['matricula'] ?? 'N/A');
                    $distrito->setValue($data['imobiliario']['distrito'] ?? 'N/A');
                    $setor->setValue($data['imobiliario']['setor'] ?? 'N/A');
                    $quadra->setValue($data['imobiliario']['quadra'] ?? 'N/A');
                    $lote->setValue($data['imobiliario']['lote'] ?? 'N/A');
                    $face->setValue($data['imobiliario']['face'] ?? 'N/A');
                    $unidade->setValue($data['imobiliario']['unidade'] ?? 'N/A');
                    $pessoa->setValue($data['pessoa']['nome'] ?? 'N/A');
                    $cep->setValue($data['cep'] ?? 'N/A');                    
                    $logradouro->setValue($data['logradouro']['nome'] ?? 'N/A');
                    $bairro->setValue($data['bairro']['nome'] ?? 'N/A');
                    $numero->setValue($data['numero'] ?? 'N/A');  
                    // Preencher o TRadioGroup conforme o retorno da API                    
                    // 9 - Medidas do Imóvel                    
                    if (!empty($data['imobiliario']['boletim'])) {
                        $arealoteValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9001') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $arealoteValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $arealote->setValue($arealoteValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $areaconstruidaValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9002') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $areaconstruidaValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $areaconstruida->setValue($areaconstruidaValor);
                    }                  
                    if (!empty($data['imobiliario']['boletim'])) {
                        $frenteValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9005') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $frenteValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $frente->setValue($frenteValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $fundoValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9006') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $fundoValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $fundo->setValue($fundoValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $numerounidadesValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9012') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $numerounidadesValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $numerounidades->setValue($numerounidadesValor);
                    }                   
                }
            }
        }
        
        // Ajuste de tamanho dos campos        
        $code->setSize('85%');
        $lote->setSize('85%');
        $face->setSize('85%');
        $setor->setSize('85%');        
        $codigo->setSize('85%');
        $quadra->setSize('85%');        
        $pessoa->setSize('365%');
        $unidade->setSize('85%');
        $bairro->setSize('182%');
        $distrito->setSize('85%');
        $matricula->setSize('100%');
        $logradouro->setSize('182%');
        $cep->setMask('99.999-999', true);  
        // 9 - Medidas do Imóvel
        $fundo->setSize('85%');
        $frente->setSize('85%');
        $arealote->setSize('85%');
        $arealivre->setSize('85%');
        $areaconstruida->setSize('85%');        
        $numerounidades->setSize('85%');       
        $fundo->setNumericMask(2, ',', '.', true);
        $frente->setNumericMask(2, ',', '.', true);
        $arealote->setNumericMask(2, ',', '.', true);
        $arealivre->setNumericMask(2, ',', '.', true);
        $areaconstruida->setNumericMask(2, ',', '.', true);        
        $numerounidades->setNumericMask(2, ',', '.', true);
        
        
        // Campo único: Inscrição
        $row1 = $this->form->addFields(
            [ new TLabel('Inscrição'), $code ]
        );
        $row1->layout = ['col-sm-4 control-label', 'col-sm-4' ];

        // Localização
        $row2 = $this->form->addFields(
            [ new TLabel('Distrito'), $distrito ],
            [ new TLabel('Setor'), $setor ],
            [ new TLabel('Quadra'), $quadra ]
        );
        $row2->layout = ['col-sm-4 control-label','col-sm-4', 'col-sm-4'];

        $row3 = $this->form->addFields(
            [ new TLabel('Lote'), $lote ],
            [ new TLabel('Face'), $face ],
            [ new TLabel('Unidade'), $unidade ]
        );
        $row3->layout = ['col-sm-4 control-label','col-sm-4', 'col-sm-4'];

        // Endereço
        $row4 = $this->form->addFields(
            [ new TLabel('Cep'), $cep ],
            [ new TLabel('Bairro'), $bairro ]
        );
        $row4->layout = ['col-sm-4', 'col-sm-4'];

        $row5 = $this->form->addFields(
            [ new TLabel('Número'), $numero ],
            [ new TLabel('Logradouro'), $logradouro ]
        );
        $row5->layout = ['col-sm-4', 'col-sm-4'];

        // Medidas
        $row6 = $this->form->addFields(
            [ new TLabel('Área do Lote'), $arealote ],
            [ new TLabel('Área Construída'), $areaconstruida ],
            [ new TLabel('Frente'), $frente ]
        );
        $row6->layout = ['col-sm-4', 'col-sm-4', 'col-sm-4'];


        // Criando botões de ação
        $this->form->addAction('Fechar', new TAction([$this, 'onClose']), 'fa:times red');

        // Chama a função para habilitar ou desabilitar campos com base no "modo"
        self::onChangeRadio(['enable' => $modo]);
               
        // Exibe o formulário na tela
        $vbox = new TVBox;
        $vbox->style = 'width: 100%';       
        $vbox->add($this->form);
        parent::add($vbox);
    }

    /**
     * onChangeRadio change - Habilita/desabilita os campos com base no "modo"
     */
    public static function onChangeRadio($param)
    {
        if ($param['enable'] == 'consulta') {
            // Campos do formulário
            TEntry::disableField('form_enable_disable', 'cep');
            TEntry::disableField('form_enable_disable', 'code');
            TEntry::disableField('form_enable_disable', 'lote');
            TEntry::disableField('form_enable_disable', 'face');
            TEntry::disableField('form_enable_disable', 'setor');
            TEntry::disableField('form_enable_disable', 'codigo');
            TEntry::disableField('form_enable_disable', 'pessoa');
            TEntry::disableField('form_enable_disable', 'bairro');
            TEntry::disableField('form_enable_disable', 'numero');
            TEntry::disableField('form_enable_disable', 'quadra');
            TEntry::disableField('form_enable_disable', 'unidade');
            TEntry::disableField('form_enable_disable', 'distrito');
            TEntry::disableField('form_enable_disable', 'matricula');
            TEntry::disableField('form_enable_disable', 'logradouro');            
            // 9 - Medidas do Imóvel
            TEntry::disableField('form_enable_disable', 'fundo');
            TEntry::disableField('form_enable_disable', 'frente');
            TEntry::disableField('form_enable_disable', 'arealote');
            TEntry::disableField('form_enable_disable', 'arealivre');
            TEntry::disableField('form_enable_disable', 'numerounidades');
            TEntry::disableField('form_enable_disable', 'areaconstruida');            

            TButton::disableField('form_enable_disable', 'saveButton'); // Oculta o botão

        } else {

            // Campos do formulário
            TEntry::enableField('form_enable_disable', 'cep');
            TEntry::enableField('form_enable_disable', 'code');
            TEntry::enableField('form_enable_disable', 'lote');
            TEntry::enableField('form_enable_disable', 'face');
            TEntry::enableField('form_enable_disable', 'setor');
            TEntry::enableField('form_enable_disable', 'codigo');
            TEntry::enableField('form_enable_disable', 'pessoa');
            TEntry::enableField('form_enable_disable', 'bairro');
            TEntry::enableField('form_enable_disable', 'numero');
            TEntry::enableField('form_enable_disable', 'quadra');
            TEntry::enableField('form_enable_disable', 'unidade');
            TEntry::enableField('form_enable_disable', 'distrito');
            TEntry::enableField('form_enable_disable', 'matricula');
            TEntry::enableField('form_enable_disable', 'logradouro');            
            // 9 - Medidas do Imóvel
            TEntry::enableField('form_enable_disable', 'fundo');
            TEntry::enableField('form_enable_disable', 'frente');
            TEntry::enableField('form_enable_disable', 'arealote');
            TEntry::enableField('form_enable_disable', 'arealivre');
            TEntry::enableField('form_enable_disable', 'numerounidades');
            TEntry::enableField('form_enable_disable', 'areaconstruida');
                        
            TButton::enableField('form_enable_disable', 'saveButton'); // Exibe o botão
        }
    }   
    /**
     * onClose
     */
    public function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }
    
}

