<?php
/**
 * Consulta_contribuinteFormView
 *
 * @version    8.0
 * @package    control
 * @subpackage admin
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class Consulta_contribuinteFormView extends TPage
{
    private $form;

    function __construct()
    {
        parent::__construct();

        parent::setTargetContainer('adianti_right_panel');

        // Pega o valor de "modo" da URL (default é 1 - Consulta)
        $modo = isset($_GET['modo']) ? $_GET['modo'] : 'consulta';

        // Cria o formulário
        $this->form = new BootstrapFormBuilder('form_enable_disable');

        // Campos do formulário        
        $cep = new TEntry('cep');
        $code = new TEntry('code');
        $lote = new TEntry('lote');
        $face = new TEntry('face');
        $setor = new TEntry('setor');
        $codigo = new TEntry('codigo');
        $pessoa = new TEntry('pessoa');
        $bairro = new TEntry('bairro');
        $numero = new TEntry('numero');
        $quadra = new TEntry('quadra');
        $unidade = new TEntry('unidade');  
        $distrito = new TEntry('distrito');
        $matricula = new TEntry('matricula');
        $logradouro = new TEntry('logradouro');
        // 1 - Informações Gerais
        $utilizacao = new TRadioGroup('utilizacao');
        $imuneisentoiptu = new TRadioGroup('imuneisentoiptu');
        $imuneisentotrsd = new TRadioGroup('imuneisentotrsd');
        // 2 - Dados Físicos do Terreno        
        $dominio = new TRadioGroup('dominio');
        $situacao = new TRadioGroup('situacao');
        $pedologia = new TRadioGroup('pedologia');
        $topografia = new TRadioGroup('topografia');
        $ocupacaolote = new TRadioGroup('ocupacaolote');
        $imovelpatrimonio = new TRadioGroup('imovelpatrimonio');
        // 3 - Fachada Principa
        $pedra = new TRadioGroup('pedra');
        $vidro = new TRadioGroup('vidro');
        $pintura = new TRadioGroup('pintura');
        $madeira = new TRadioGroup('madeira'); 
        $metalico = new TRadioGroup('metalico');
        $ceramica = new TRadioGroup('ceramica');
        // 4 - Alinhamento
        $alinhamento = new TRadioGroup('alinhamento');
        $posicionamento = new TRadioGroup('posicionamento');
        // 5 - Esquadrias
        $esquadriasvidro = new TRadioGroup('esquadriasvidro');
        $esquadriasmadeira = new TRadioGroup('esquadriasmadeira');
        $esquadriasmetalico = new TRadioGroup('esquadriasmetalico');        
        // 6 - Dados Físico da Edificação        
        $paredes = new TRadioGroup('paredes');
        $cobertura = new TRadioGroup('cobertura');
        $estrutura = new TRadioGroup('estrutura');
        // 7 - Equipamentos Especiais
        $equipamentosespeciais = new TCheckGroup('equipamentosespeciais');
        // 8 - Dados Físico da Edificação
        $piso = new TRadioGroup('piso');
        $forro = new TRadioGroup('forro');
        $edificacao = new TRadioGroup('edificacao');
        $condominio = new TRadioGroup('condominio'); 
        $estadoconservacao = new TRadioGroup('estadoconservacao');       
        $instalacaoeletrica = new TRadioGroup('instalacaoeletrica');
        $instalacaosanitaria = new TRadioGroup('instalacaosanitaria'); 
        // 9 - Medidas do Imóvel
        $fundo = new TEntry('fundo');
        $frente = new TEntry('frente');
        $arealote = new TEntry('arealote');
        $arealivre = new TEntry('arealivre');
        $numerounidades = new TEntry('numerounidades');
        $areaconstruida = new TEntry('areaconstruida');
        $lateraldireita = new TEntry('lateraldireita');  
        $lateralesquerda = new TEntry('lateralesquerda');
        $testadaconstrucao = new TEntry('testadaconstrucao');
        $areatotalconstruida = new TEntry('areatotalconstruida');
        $profundidadeterreno = new TEntry('profundidadeterreno');
        $quantidadepavimentos = new TEntry('quantidadepavimentos');
        $profundidadeconstrucao = new TEntry('profundidadeconstrucao');  
        // 10 - Matrícula Cartório
        $matriculacartorio = new TText('matriculacartorio');        
        
        // 1 - Informações Gerais
        $optionsutilizacao = [
            1 => '1 - Terreno Sem Uso', 2 => '2 - Residencial', 3 => '3 - Industrial', 4 => '4 - Outros',
            5 => '5 - Comercio/Serviços', 6 => '6 - Rural', 7 => '7 - Religioso', 10 => '10 - Institucional'
        ];
        $optionsimuneisentoiptu = [
            1 => '1 - Não', 2 => '2 - Imune', 3 => '3 - Isento',            
        ];
        $optionsimuneisentotrsd = [
            1 => '1 - Não', 2 => '2 - Imune', 3 => '3 - Isento',            
        ];
        // 2 - Dados Físicos do Terreno
        $optionsocupacaolote = [
            1 => '1 - Não Construído', 2 => '2 - Ruínas', 3 => '3 - Em Demolição', 4 => '4 - Construção Paralisada',
            5 => '5 - Construção em Andamento', 6 => '6 - Construído',
        ];
        $optionsimovelpatrimonio = [
            1 => '1 - Público', 2 => '2 - Particular', 3 => '3 - Religioso',
        ];
        $optionsdominio = [
            1 => '1 - Particular', 2 => '2 - Foreiro', 3 => '3 - Público',
        ];
        $optionssituacao = [
            1 => '1 - Meio de quadra', 2 => '2 - Esquina Mais de Uma Frente', 3 => '3 - Vila', 4 => '4 - Encravado',
            5 => '5 - Gleba', 6 => '6 - Duas Frentes', 7 => '7 - Quadra', 8 => '8 - Aglomerado',
        ];
        $optionstopografia = [
            1 => '1 - Plano', 2 => '2 - Aclive', 3 => '3 - Declive', 4 => '4 - Irregular',
        ];
        $optionspedologia = [
            1 => '1 - Inundável', 2 => '2 - Firme', 3 => '3 - Alagado', 4 => '4 - Combinação das Demais',
            5 => '5 - Rochoso', 6 => '6 - Arenoso',
        ];  
        // 3 - Fachada Principa
        $optionspintura = [
            1 => '1 - Sem Pintura', 2 => '2 - Pintura Simples', 3 => '3 - Pintura com Textura',
        ];
        $optionsmadeira = [
            1 => '1 - Simples', 2 => '2 - Especial',
        ];
        $optionsceramica = [
            1 => '1 - Cerâmica Simples/Lajota', 2 => '2 - Cerâmica Especial 1 (Cacos de Cerâmica/Mosaico)', 3 => '3 - Cerâmica Especial 2 (Pastilha)',
            4 => '4 - Cerâmica Especial 3 (Porcelanato)',
        ];
        $optionspedra = [
            1 => '1 - Pedra 1 (Natural/Rústica/Artesanal)', 2 => '2 - Pedra 2 (Ornamental)', 3 => '3 - Pedra 3 (Granito)',
        ];
        $optionsvidro = [
            1 => '1 - Vidro 1 (Temperado)', 2 => '2 - Vidro 2 (Espelhado)',
        ];
        $optionsmetalico = [
            1 => '1 - Ferro',
        ];  
        // 4 - Alinhamento
        $optionsalinhamento = [
            1 => '1 - Recuada', 2 => '2 - Recuada com Muro Alinhado', 3 => '3 - Alinhada',
        ];
        $optionsposicionamento = [
            1 => '1 - Isolada', 2 => '2 - Conjugada', 3 => '3 - Geminada',
        ];
        // 5 - Esquadrias
        $optionsesquadriasmadeira = [
            1 => '1 - Sem Pintura', 2 => '2 - Pintura Simples', 3 => '3 - Pintura com Textura',
        ]; 
        $optionsesquadriasmetalico = [
            1 => '1 - Ferro', 2 => '2 - Aço', 3 => '3 - Zincada', 4 => '4 - Chapa',
            5 => '5 - Alumínio Simples', 6 => '6 - Alumínio Anodizado',
        ]; 
        $optionsesquadriasvidro = [
            1 => '1 - Vidro 1 (Temperado)', 2 => '2 - Vidro 2 (Espelhado)',
        ];
        // 6 - Característica Estrutura
        $optionsestrutura = [
            1 => '1 - Alvenaria', 2 => '2 - Concreto', 3 => '3 - Metálica', 4 => '4 - Madeira',
        ]; 
        $optionsparedes = [
            1 => '1 - Refugo', 2 => '2 - Tijolo', 3 => '3 - Adobe', 4 => '4 - Pedra',
            5 => '5 - Gesso', 6 => '6 - Placa de Concreto', 7 => '7 - Madeira', 8 => '8 - Vidro',
        ]; 
        $optionscobertura = [
            1 => '1 - Telha 1 (Marombada)', 2 => '2 - Tela 2 (Paulistinha)', 3 => '3 - Telha 3 (Colonial)', 4 => '4 - Metálica',
            5 => '5 - Fibrocimento', 6 => '6 - Laje Impermeabilizada',
        ]; 
        // 7 - Equipamentos Especiais
        $optionsequipamentosespeciais = [
            1 => '1 - Central de Ar Condicionador', 2 => '2 - Piscina Coberta / Aquecida', 3 => '3 - Piscina Comum', 4 => '4 - Piscina Comum (Coletiva)',
            5 => '5 - Quadra Poliesportiva Coberta', 6 => '6 - Quadra Poliesportiva Descoberta', 7 => '7 - Bar / Churrasqueira', 8 => '8 - Refeitório',
            9 => '9 - Guarita', 10 => '10 - Saúna', 11 => '11 - Portão Eletrônico', 12 => '12 - Lavanderia Industrial',
            13 => '13 - Elevador Social', 14 => '14 - Elevador de Serviço', 15 => '15 - Hidromassagem', 16 => '16 - Salão de Festas',
            17 => '17 - Play Ground', 18 => '18 - Academia de Ginástica', 19 => '19 - Clube', 20 => '20 - Pista de Cooper',
            21 => '21 - Quadra de Tênis', 22 => '22 - Garagem de Estacionamento - 1 Vaga', 23 => '23 - Garagem de Estacionamento - 2 a 5 Vagas', 24 => '24 - Garagem de Estacionamento - 6 a 10 Vagas',
            25 => '25 - Garagem de Estacionamento - 11 a 15 Vagas', 26 => '26 - Garagem de Estacionamento - 16 a 20 Vagas', 27 => '27 - Garagem de Estacionamento - 20 a 25 Vagas', 28 => '28 - Garagem de Estacionamento - 25 a 30 Vagas',
            28 => '28 - Garagem de Estacionamento - 25 a 30 Vagas', 29 => '29 - Garagem de Estacionamento - Acima de 30 Vagas', 30 => '30 - Escada Rolante', 31 => '31 - Auditório',
            32 => '32 - Circuito Interno de TV',
        ];
        // 8 - Dados Físico da Edificação
        $optionsedificacao = [
            1 => '1 - Residencial', 2 => '2 - Comercial', 3 => '3 - Prédio', 4 => '4 - Industrial',
            5 => '5 - Galpão com Paredes', 6 => '6 - Container', 7 => '7 - Cobertura/Galpão sem Paredes',
        ]; 
        $optionscondominio = [
            1 => '1 - Não', 2 => '2 - Horizontal', 3 => '3 - Vertical',            
        ]; 
        $optionsinstalacaosanitaria = [
            1 => '1 - Sem', 2 => '2 - Externa', 3 => '3 - Mais de Uma Interna', 4 => '4 - Interna Simples',
            5 => '5 - Interna Completa',
        ]; 
        $optionsinstalacaoeletrica = [
            1 => '1 - Externa', 2 => '2 - Embutida',            
        ]; 
        $optionspiso = [
            1 => '1 - Terra Batida', 2 => '2 - Cimento', 3 => '3 - Cerâmica/Mosaico', 4 => '4 - Madeira',
            5 => '5 - Especial/Porcelanato',
        ]; 
        $optionsestadoconservacao = [
            1 => '1 - Ótima', 2 => '2 - Bom', 3 => '3 - Regular', 4 => '4 - Ruim',            
        ]; 
        $optionsforro = [
            1 => '1 - Sem', 2 => '2 - Madeira', 4 => '4 - Estuque', 5 => '5 - Lage',
            6 => '6 - Gesso', 7 => '7 - PVC',
        ]; 

        // 1 - Informações Gerais                        
        $utilizacao->setSize(200);
        $utilizacao->setLayout('horizontal');
        $utilizacao->addItems($optionsutilizacao);                       
        $imuneisentoiptu->setSize(200);
        $imuneisentoiptu->setLayout('horizontal');
        $imuneisentoiptu->addItems($optionsimuneisentoiptu);                        
        $imuneisentotrsd->setSize(200);
        $imuneisentotrsd->setLayout('horizontal');
        $imuneisentotrsd->addItems($optionsimuneisentotrsd); 
        // 2 - Dados Físicos do Terreno                        
        $ocupacaolote->setSize(200);
        $ocupacaolote->setLayout('horizontal');
        $ocupacaolote->addItems($optionsocupacaolote);                        
        $imovelpatrimonio->setSize(200);
        $imovelpatrimonio->setLayout('horizontal');
        $imovelpatrimonio->addItems($optionsimovelpatrimonio);                        
        $dominio->setSize(200);
        $dominio->setLayout('horizontal');
        $dominio->addItems($optionsdominio);                       
        $situacao->setSize(200);
        $situacao->setLayout('horizontal');
        $situacao->addItems($optionssituacao);                         
        $topografia->setSize(200);
        $topografia->setLayout('horizontal');
        $topografia->addItems($optionstopografia);                        
        $pedologia->setSize(200);
        $pedologia->setLayout('horizontal');
        $pedologia->addItems($optionspedologia);
        // 3 - Fachada Principa                        
        $pintura->setSize(200);
        $pintura->setLayout('horizontal');
        $pintura->addItems($optionspintura);                       
        $madeira->setSize(200);
        $madeira->setLayout('horizontal');
        $madeira->addItems($optionsmadeira);                         
        $ceramica->setSize(200);
        $ceramica->setLayout('horizontal');
        $ceramica->addItems($optionsceramica);                       
        $pedra->setSize(200); 
        $pedra->setLayout('horizontal');
        $pedra->addItems($optionspedra);                         
        $vidro->setSize(200);
        $vidro->setLayout('horizontal');
        $vidro->addItems($optionsvidro);                        
        $metalico->setSize(200);
        $metalico->setLayout('horizontal');
        $metalico->addItems($optionsmetalico); 
        // 4 - Alinhamento
        $alinhamento->setSize(200);
        $alinhamento->setLayout('horizontal');
        $alinhamento->addItems($optionsalinhamento);                       
        $posicionamento->setSize(200);
        $posicionamento->setLayout('horizontal');
        $posicionamento->addItems($optionsposicionamento); 
        // 5 - Esquadrias
        $esquadriasmadeira->setSize(200); 
        $esquadriasmadeira->setLayout('horizontal');
        $esquadriasmadeira->addItems($optionsesquadriasmadeira);                        
        $esquadriasmetalico->setSize(200); 
        $esquadriasmetalico->setLayout('horizontal');
        $esquadriasmetalico->addItems($optionsesquadriasmetalico);                       
        $esquadriasvidro->setSize(200);  
        $esquadriasvidro->setLayout('horizontal');
        $esquadriasvidro->addItems($optionsesquadriasvidro); 
        // 6 - Característica Estrutura
        $estrutura->setSize(200);
        $estrutura->setLayout('horizontal');
        $estrutura->addItems($optionsestrutura);                       
        $paredes->setSize(200);
        $paredes->setLayout('horizontal');
        $paredes->addItems($optionsparedes);                        
        $cobertura->setSize(200);
        $cobertura->setLayout('horizontal');
        $cobertura->addItems($optionscobertura);
        // 7 - Equipamentos Especiais                        
        $equipamentosespeciais->setSize(200);
        $equipamentosespeciais->setLayout('horizontal');
        $equipamentosespeciais->addItems($optionsequipamentosespeciais);
        // 8 - Dados Físico da Edificação                       
        $edificacao->setSize(200); 
        $edificacao->setLayout('horizontal');
        $edificacao->addItems($optionsedificacao);                        
        $condominio->setSize(200); 
        $condominio->setLayout('horizontal');
        $condominio->addItems($optionscondominio);                         
        $instalacaosanitaria->setSize(200); 
        $instalacaosanitaria->setLayout('horizontal');
        $instalacaosanitaria->addItems($optionsinstalacaosanitaria);
        $instalacaoeletrica->setSize(200);
        $instalacaoeletrica->setLayout('horizontal');
        $instalacaoeletrica->addItems($optionsinstalacaoeletrica);                       
        $piso->setSize(200);
        $piso->setLayout('horizontal');
        $piso->addItems($optionspiso);                         
        $estadoconservacao->setSize(200);
        $estadoconservacao->setLayout('horizontal');
        $estadoconservacao->addItems($optionsestadoconservacao);                       
        $forro->setSize(200);
        $forro->setLayout('horizontal');
        $forro->addItems($optionsforro); 
        // 10 - Matrícula Cartório
        $matriculacartorio->setSize('100%', 50);
        
        function getUrlContent($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

// Buscar dados da API se houver inscrição
if (!empty($_GET['inscricao'])) {
    $inscricao = $_GET['inscricao'];
    $code->setValue($inscricao);

    // URL completa
    $url = "http://geojequie.sisprom-br.com.br/vendor/geojequie/consulta_inscricao_el.php?inscricao=" . urlencode($inscricao);
    $response = getUrlContent($url);

    if ($response) {
        $data = json_decode($response, true);
        
        if ($data) {
                    $codigo->setValue($data['codigo'] ?? 'N/A');
                    $matricula->setValue($data['imobiliario']['matricula'] ?? 'N/A');
                    $distrito->setValue($data['imobiliario']['distrito'] ?? 'N/A');
                    $setor->setValue($data['imobiliario']['setor'] ?? 'N/A');
                    $quadra->setValue($data['imobiliario']['quadra'] ?? 'N/A');
                    $lote->setValue($data['imobiliario']['lote'] ?? 'N/A');
                    $face->setValue($data['imobiliario']['face'] ?? 'N/A');
                    $unidade->setValue($data['imobiliario']['unidade'] ?? 'N/A');
                    $pessoa->setValue($data['pessoa']['nome'] ?? 'N/A');
                    $cep->setValue($data['cep'] ?? 'N/A');                    
                    $logradouro->setValue($data['logradouro']['nome'] ?? 'N/A');
                    $bairro->setValue($data['bairro']['nome'] ?? 'N/A');
                    $numero->setValue($data['numero'] ?? 'N/A');  
                    // Preencher o TRadioGroup conforme o retorno da API
                    // 1 - Informações Gerais
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '1001') {
                                // Se encontrar, pega o id da resposta
                                $utilizacaoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsutilizacao[$utilizacaoValor])) {
                                    $utilizacao->setValue($utilizacaoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '1003') {
                                // Se encontrar, pega o id da resposta
                                $imuneisentoiptuValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsimuneisentoiptu[$imuneisentoiptuValor])) {
                                    $imuneisentoiptu->setValue($imuneisentoiptuValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '1004') {
                                // Se encontrar, pega o id da resposta
                                $imuneisentotrsdValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsimuneisentotrsd[$imuneisentotrsdValor])) {
                                    $imuneisentotrsd->setValue($imuneisentotrsdValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 2 - Dados Físicos do Terreno
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2001') {
                                // Se encontrar, pega o id da resposta
                                $ocupacaoloteValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsocupacaolote[$ocupacaoloteValor])) {
                                    $ocupacaolote->setValue($ocupacaoloteValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2002') {
                                // Se encontrar, pega o id da resposta
                                $imovelpatrimonioValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsimovelpatrimonio[$imovelpatrimonioValor])) {
                                    $imovelpatrimonio->setValue($imovelpatrimonioValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2003') {
                                // Se encontrar, pega o id da resposta
                                $dominioValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsdominio[$dominioValor])) {
                                    $dominio->setValue($dominioValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2004') {
                                // Se encontrar, pega o id da resposta
                                $situacaoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionssituacao[$situacaoValor])) {
                                    $situacao->setValue($situacaoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    }                     
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2005') {
                                // Se encontrar, pega o id da resposta
                                $topografiaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionstopografia[$topografiaValor])) {
                                    $topografia->setValue($topografiaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '2006') {
                                // Se encontrar, pega o id da resposta
                                $pedologiaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionspedologia[$pedologiaValor])) {
                                    $pedologia->setValue($pedologiaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 3 - Fachada Principa
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3001') {
                                // Se encontrar, pega o id da resposta
                                $pinturaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionspintura[$pinturaValor])) {
                                    $pintura->setValue($pinturaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3002') {
                                // Verifica se 'resposta' e 'id' existem antes de acessar
                                $madeiraValor = $item['resposta']['id'] ?? null;
                    
                                if ($madeiraValor !== null && isset($optionsmadeira[$madeiraValor])) {
                                    $madeira->setValue($madeiraValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3003') {
                                // Se encontrar, pega o id da resposta
                                $ceramicaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsceramica[$ceramicaValor])) {
                                    $ceramica->setValue($ceramicaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3004') {
                                // Se encontrar, pega o id da resposta
                                $pedraValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionspedra[$pedraValor])) {
                                    $pedra->setValue($pedraValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3005') {
                                // Se encontrar, pega o id da resposta
                                $vidroValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsvidro[$vidroValor])) {
                                    $vidro->setValue($vidroValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '3006') {
                                // Se encontrar, pega o id da resposta
                                $metalicoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsmetalico[$metalicoValor])) {
                                    $metalico->setValue($metalicoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 4 - Alinhamento
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '4001') {
                                // Se encontrar, pega o id da resposta
                                $alinhamentoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsalinhamento[$alinhamentoValor])) {
                                    $alinhamento->setValue($alinhamentoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '4002') {
                                // Se encontrar, pega o id da resposta
                                $posicionamentoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsposicionamento[$posicionamentoValor])) {
                                    $posicionamento->setValue($posicionamentoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 5 - Esquadrias
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '5001') {
                                // Se encontrar, pega o id da resposta
                                $esquadriasmadeiraValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsesquadriasmadeira[$esquadriasmadeiraValor])) {
                                    $esquadriasmadeira->setValue($esquadriasmadeiraValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '5002') {
                                // Se encontrar, pega o id da resposta
                                $esquadriasmetalicoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsesquadriasmetalico[$esquadriasmetalicoValor])) {
                                    $esquadriasmetalico->setValue($esquadriasmetalicoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '5004') {
                                // Se encontrar, pega o id da resposta
                                $esquadriasvidroValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsesquadriasvidro[$esquadriasvidroValor])) {
                                    $esquadriasvidro->setValue($esquadriasvidroValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 6 - Característica Estrutura
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '6001') {
                                // Se encontrar, pega o id da resposta
                                $estruturaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsestrutura[$estruturaValor])) {
                                    $estrutura->setValue($estruturaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '6002') {
                                // Se encontrar, pega o id da resposta
                                $paredesValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsparedes[$paredesValor])) {
                                    $paredes->setValue($paredesValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '6003') {
                                // Se encontrar, pega o id da resposta
                                $coberturaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionscobertura[$coberturaValor])) {
                                    $cobertura->setValue($coberturaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 7 - Equipamentos Especiais
                    if (!empty($data['imobiliario']['boletim'])) {
                        $validItems = [];

                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o desejado
                            if ($item['campo'] == '7001' && isset($item['resposta']['id'])) {
                                // Adiciona o ID à lista se for válido
                                if (isset($optionsequipamentosespeciais[$item['resposta']['id']])) {
                                    $validItems[] = $item['resposta']['id'];
                                }
                            }
                        }

                        // Define os valores múltiplos no campo de seleção
                        if (!empty($validItems)) {
                            $equipamentosespeciais->setValue($validItems);
                        } else {
                            $equipamentosespeciais->setValue([]); // Define vazio caso não tenha valores
                        }
                    }
                    // 8 - Dados Físico da Edificação
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8001') {
                                // Se encontrar, pega o id da resposta
                                $edificacaoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsedificacao[$edificacaoValor])) {
                                    $edificacao->setValue($edificacaoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8003') {
                                // Se encontrar, pega o id da resposta
                                $condominioValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionscondominio[$condominioValor])) {
                                    $condominio->setValue($condominioValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8004') {
                                // Se encontrar, pega o id da resposta
                                $instalacaosanitariaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsinstalacaosanitaria[$instalacaosanitariaValor])) {
                                    $instalacaosanitaria->setValue($instalacaosanitariaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8005') {
                                // Se encontrar, pega o id da resposta
                                $instalacaoeletricaValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsinstalacaoeletrica[$instalacaoeletricaValor])) {
                                    $instalacaoeletrica->setValue($instalacaoeletricaValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8006') {
                                // Se encontrar, pega o id da resposta
                                $pisoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionspiso[$pisoValor])) {
                                    $piso->setValue($pisoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8007') {
                                // Se encontrar, pega o id da resposta
                                $estadoconservacaoValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsestadoconservacao[$estadoconservacaoValor])) {
                                    $estadoconservacao->setValue($estadoconservacaoValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    if (!empty($data['imobiliario']['boletim'])) {
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '8009') {
                                // Se encontrar, pega o id da resposta
                                $forroValor = $item['resposta']['id'] ?? null; 
                    
                                // Verifica se o valor existe nas opções
                                if (isset($optionsforro[$forroValor])) {
                                    $forro->setValue($forroValor);  // Define o valor no TRadioGroup
                                }
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                    } 
                    // 9 - Medidas do Imóvel                    
                    if (!empty($data['imobiliario']['boletim'])) {
                        $arealoteValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9001') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $arealoteValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $arealote->setValue($arealoteValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $areaconstruidaValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9002') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $areaconstruidaValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $areaconstruida->setValue($areaconstruidaValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $areatotalconstruidaValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9003') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $areatotalconstruidaValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $areatotalconstruida->setValue($areatotalconstruidaValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $quantidadepavimentosValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9004') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $quantidadepavimentosValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $quantidadepavimentos->setValue($quantidadepavimentosValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $frenteValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9005') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $frenteValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $frente->setValue($frenteValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $fundoValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9006') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $fundoValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $fundo->setValue($fundoValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $lateralesquerdaValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9007') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $lateralesquerdaValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $lateralesquerda->setValue($lateralesquerdaValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $lateraldireitaValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9008') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $lateraldireitaValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $lateraldireita->setValue($lateraldireitaValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $profundidadeterrenoValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9009') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $profundidadeterrenoValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $profundidadeterreno->setValue($profundidadeterrenoValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $testadaconstrucaoValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9010') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $testadaconstrucaoValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $testadaconstrucao->setValue($testadaconstrucaoValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $profundidadeconstrucaoValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9011') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $profundidadeconstrucaoValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $profundidadeconstrucao->setValue($profundidadeconstrucaoValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $numerounidadesValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9012') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $numerounidadesValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $numerounidades->setValue($numerounidadesValor);
                    }
                    if (!empty($data['imobiliario']['boletim'])) {
                        $arealivreValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '9013') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $arealivreValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $arealivre->setValue($arealivreValor);
                    }                 
                    // 10 - Matrícula Cartório
                    if (!empty($data['imobiliario']['boletim'])) {
                        $matriculacartorioValor = 'N/A';  // Valor padrão, caso o campo não seja encontrado
                        foreach ($data['imobiliario']['boletim'] as $item) {
                            // Verifica se o campo é o que você está procurando
                            if ($item['campo'] == '10001') {  // Substitua '31' pelo campo que você precisa
                                // Se encontrar, pega a descrição da resposta
                                $matriculacartorioValor = $item['resposta']['descricao'] ?? 'N/A'; 
                                break; // Sai do loop assim que encontrar o item
                            }
                        }
                        // Define o valor no TRadioGroup
                        $matriculacartorio->setValue($matriculacartorioValor);
                    };                    
                }
            }
        }
        // Ajuste de tamanho dos campos        
        $code->setSize('85%');
        $lote->setSize('85%');
        $face->setSize('85%');
        $setor->setSize('85%');        
        $codigo->setSize('85%');
        $quadra->setSize('85%');        
        $pessoa->setSize('365%');
        $unidade->setSize('85%');
        $bairro->setSize('182%');
        $distrito->setSize('85%');
        $matricula->setSize('100%');
        $logradouro->setSize('182%');
        $cep->setMask('99.999-999', true);  
        // 9 - Medidas do Imóvel
        $fundo->setSize('85%');
        $frente->setSize('85%');
        $arealote->setSize('85%');
        $arealivre->setSize('85%');
        $areaconstruida->setSize('85%');
        $lateraldireita->setSize('85%');
        $numerounidades->setSize('85%');
        $lateralesquerda->setSize('85%');
        $testadaconstrucao->setSize('85%');
        $areatotalconstruida->setSize('85%');
        $profundidadeterreno->setSize('85%');
        $quantidadepavimentos->setSize('85%');
        $profundidadeconstrucao->setSize('85%');
        $fundo->setNumericMask(2, ',', '.', true);
        $frente->setNumericMask(2, ',', '.', true);
        $arealote->setNumericMask(2, ',', '.', true);
        $arealivre->setNumericMask(2, ',', '.', true);
        $areaconstruida->setNumericMask(2, ',', '.', true);
        $lateraldireita->setNumericMask(2, ',', '.', true);
        $numerounidades->setNumericMask(2, ',', '.', true);
        $lateralesquerda->setNumericMask(2, ',', '.', true);
        $testadaconstrucao->setNumericMask(2, ',', '.', true);
        $areatotalconstruida->setNumericMask(2, ',', '.', true);
        $profundidadeterreno->setNumericMask(2, ',', '.', true);
        $quantidadepavimentos->setNumericMask(2, ',', '.', true);
        $profundidadeconstrucao->setNumericMask(2, ',', '.', true);
        
        // Adicionando campos ao formulário
        $row1 = $this->form->addFields(
            [ new TLabel('Inscrição'), $code ],
            [ new TLabel('Sequencial do Contribuinte*'), $codigo ],
            [ new TLabel('Matricula'), $matricula ]);
        $row1->layout = ['col-sm-3', 'col-sm-4', 'col-sm-3'];
        $row2 = $this->form->addFields(
            [ new TLabel('Nome'), $pessoa ]);
        $row2->layout = ['col-sm-3'];
        $row3 = $this->form->addFields(
            [ new TLabel('Distrito'), $distrito ], 
            [ new TLabel('Setor'), $setor ],
            [ new TLabel('Quadra'), $quadra ], 
            [ new TLabel('Lote'), $lote ],
            [ new TLabel('Face'), $face ], 
            [ new TLabel('Unidade'), $unidade ]);
        $row3->layout = ['col-sm-4', 'col-sm-4', 'col-sm-4', 'col-sm-4', 'col-sm-4', 'col-sm-4'];
        $row4 = $this->form->addFields(
            [ new TLabel('Cep'), $cep ], 
            [ new TLabel('Logradouro*'), $logradouro ]);
        $row4->layout = ['col-sm-3', 'col-sm-4'];
        $row5 = $this->form->addFields(
            [ new TLabel('Bairro*'), $bairro ]);
        $row5->layout = ['col-sm-3', 'col-sm-4'];

        // Criando botões de ação
        $this->form->addAction('Fechar', new TAction([$this, 'onClose']), 'fa:times red');

        // Chama a função para habilitar ou desabilitar campos com base no "modo"
        self::onChangeRadio(['enable' => $modo]);

        // Botão Save
        $this->saveButton = $this->form->addAction('Editar', new TAction([$this, 'onSend']), 'fa:rocket');
        $this->saveButton->setName('saveButton');

         // Botão Export
        $btn = TButton::create('btn_pdf', [$this, 'exportAsPDF'], 'Exportar como PDF', 'fa:file-pdf-o red');
        $this->form->addAction( 'Exportar PDF',  new TAction([$this, 'exportAsPDF']), 'fa:file-pdf-o red' );
       
        // Exibe o formulário na tela
        $vbox = new TVBox;
        $vbox->style = 'width: 100%';       
        $vbox->add($this->form);
        parent::add($vbox);
    }

    /**
     * onChangeRadio change - Habilita/desabilita os campos com base no "modo"
     */
    public static function onChangeRadio($param)
    {
        if ($param['enable'] == 'consulta') {
            // Campos do formulário
            TEntry::disableField('form_enable_disable', 'cep');
            TEntry::disableField('form_enable_disable', 'code');
            TEntry::disableField('form_enable_disable', 'lote');
            TEntry::disableField('form_enable_disable', 'face');
            TEntry::disableField('form_enable_disable', 'setor');
            TEntry::disableField('form_enable_disable', 'codigo');
            TEntry::disableField('form_enable_disable', 'pessoa');
            TEntry::disableField('form_enable_disable', 'bairro');
            TEntry::disableField('form_enable_disable', 'numero');
            TEntry::disableField('form_enable_disable', 'quadra');
            TEntry::disableField('form_enable_disable', 'unidade');
            TEntry::disableField('form_enable_disable', 'distrito');
            TEntry::disableField('form_enable_disable', 'matricula');
            TEntry::disableField('form_enable_disable', 'logradouro');
            // 1 - Informações Gerais
            TRadioGroup::disableField('form_enable_disable', 'utilizacao');
            TRadioGroup::disableField('form_enable_disable', 'imuneisentoiptu');
            TRadioGroup::disableField('form_enable_disable', 'imuneisentotrsd');
            // 2 - Dados Físicos do Terreno  
            TRadioGroup::disableField('form_enable_disable', 'dominio');
            TRadioGroup::disableField('form_enable_disable', 'situacao');
            TRadioGroup::disableField('form_enable_disable', 'pedologia');
            TRadioGroup::disableField('form_enable_disable', 'topografia');
            TRadioGroup::disableField('form_enable_disable', 'ocupacaolote');
            TRadioGroup::disableField('form_enable_disable', 'imovelpatrimonio');
            // 3 - Fachada Principa
            TRadioGroup::disableField('form_enable_disable', 'pedra');
            TRadioGroup::disableField('form_enable_disable', 'vidro');
            TRadioGroup::disableField('form_enable_disable', 'pintura');
            TRadioGroup::disableField('form_enable_disable', 'madeira');
            TRadioGroup::disableField('form_enable_disable', 'metalico');
            TRadioGroup::disableField('form_enable_disable', 'ceramica');
            // 4 - Alinhamento
            TRadioGroup::disableField('form_enable_disable', 'alinhamento');
            TRadioGroup::disableField('form_enable_disable', 'posicionamento');
            // 5 - Esquadrias
            TRadioGroup::disableField('form_enable_disable', 'esquadriasvidro');
            TRadioGroup::disableField('form_enable_disable', 'esquadriasmadeira');
            TRadioGroup::disableField('form_enable_disable', 'esquadriasmetalico');
            // 6 - Dados Físico da Edificação 
            TRadioGroup::disableField('form_enable_disable', 'paredes');
            TRadioGroup::disableField('form_enable_disable', 'cobertura');
            TRadioGroup::disableField('form_enable_disable', 'estrutura');
            // 7 - Equipamentos Especiais
            TRadioGroup::disableField('form_enable_disable', 'equipamentosespeciais');
            // 8 - Dados Físico da Edificação
            TRadioGroup::disableField('form_enable_disable', 'piso');
            TRadioGroup::disableField('form_enable_disable', 'forro');
            TRadioGroup::disableField('form_enable_disable', 'edificacao');
            TRadioGroup::disableField('form_enable_disable', 'condominio');
            TRadioGroup::disableField('form_enable_disable', 'estadoconservacao');
            TRadioGroup::disableField('form_enable_disable', 'instalacaoeletrica');
            TRadioGroup::disableField('form_enable_disable', 'instalacaosanitaria');
            // 9 - Medidas do Imóvel
            TEntry::disableField('form_enable_disable', 'fundo');
            TEntry::disableField('form_enable_disable', 'frente');
            TEntry::disableField('form_enable_disable', 'arealote');
            TEntry::disableField('form_enable_disable', 'arealivre');
            TEntry::disableField('form_enable_disable', 'numerounidades');
            TEntry::disableField('form_enable_disable', 'areaconstruida');
            TEntry::disableField('form_enable_disable', 'lateraldireita');
            TEntry::disableField('form_enable_disable', 'lateralesquerda');
            TEntry::disableField('form_enable_disable', 'testadaconstrucao');
            TEntry::disableField('form_enable_disable', 'areatotalconstruida');
            TEntry::disableField('form_enable_disable', 'profundidadeterreno');
            TEntry::disableField('form_enable_disable', 'quantidadepavimentos');
            TEntry::disableField('form_enable_disable', 'profundidadeconstrucao');
            // 10 - Matrícula Cartório
            TText::disableField('form_enable_disable', 'matriculacartorio');

            TButton::disableField('form_enable_disable', 'saveButton'); // Oculta o botão

        } else {

            // Campos do formulário
            TEntry::enableField('form_enable_disable', 'cep');
            TEntry::enableField('form_enable_disable', 'code');
            TEntry::enableField('form_enable_disable', 'lote');
            TEntry::enableField('form_enable_disable', 'face');
            TEntry::enableField('form_enable_disable', 'setor');
            TEntry::enableField('form_enable_disable', 'codigo');
            TEntry::enableField('form_enable_disable', 'pessoa');
            TEntry::enableField('form_enable_disable', 'bairro');
            TEntry::enableField('form_enable_disable', 'numero');
            TEntry::enableField('form_enable_disable', 'quadra');
            TEntry::enableField('form_enable_disable', 'unidade');
            TEntry::enableField('form_enable_disable', 'distrito');
            TEntry::enableField('form_enable_disable', 'matricula');
            TEntry::enableField('form_enable_disable', 'logradouro');
            // 1 - Informações Gerais
            TRadioGroup::enableField('form_enable_disable', 'utilizacao');
            TRadioGroup::enableField('form_enable_disable', 'imuneisentoiptu');
            TRadioGroup::enableField('form_enable_disable', 'imuneisentotrsd');
            // 2 - Dados Físicos do Terreno  
            TRadioGroup::enableField('form_enable_disable', 'dominio');
            TRadioGroup::enableField('form_enable_disable', 'situacao');
            TRadioGroup::enableField('form_enable_disable', 'pedologia');
            TRadioGroup::enableField('form_enable_disable', 'topografia');
            TRadioGroup::enableField('form_enable_disable', 'ocupacaolote');
            TRadioGroup::enableField('form_enable_disable', 'imovelpatrimonio');
            // 3 - Fachada Principa
            TRadioGroup::enableField('form_enable_disable', 'pedra');
            TRadioGroup::enableField('form_enable_disable', 'vidro');
            TRadioGroup::enableField('form_enable_disable', 'pintura');
            TRadioGroup::enableField('form_enable_disable', 'madeira');
            TRadioGroup::enableField('form_enable_disable', 'metalico');
            TRadioGroup::enableField('form_enable_disable', 'ceramica');
            // 4 - Alinhamento
            TRadioGroup::enableField('form_enable_disable', 'alinhamento');
            TRadioGroup::enableField('form_enable_disable', 'posicionamento');
            // 5 - Esquadrias
            TRadioGroup::enableField('form_enable_disable', 'esquadriasvidro');
            TRadioGroup::enableField('form_enable_disable', 'esquadriasmadeira');
            TRadioGroup::enableField('form_enable_disable', 'esquadriasmetalico');
            // 6 - Dados Físico da Edificação 
            TRadioGroup::enableField('form_enable_disable', 'paredes');
            TRadioGroup::enableField('form_enable_disable', 'cobertura');
            TRadioGroup::enableField('form_enable_disable', 'estrutura');
            // 7 - Equipamentos Especiais
            TRadioGroup::enableField('form_enable_disable', 'equipamentosespeciais');
            // 8 - Dados Físico da Edificação
            TRadioGroup::enableField('form_enable_disable', 'piso');
            TRadioGroup::enableField('form_enable_disable', 'forro');
            TRadioGroup::enableField('form_enable_disable', 'edificacao');
            TRadioGroup::enableField('form_enable_disable', 'condominio');
            TRadioGroup::enableField('form_enable_disable', 'estadoconservacao');
            TRadioGroup::enableField('form_enable_disable', 'instalacaoeletrica');
            TRadioGroup::enableField('form_enable_disable', 'instalacaosanitaria');
            // 9 - Medidas do Imóvel
            TEntry::enableField('form_enable_disable', 'fundo');
            TEntry::enableField('form_enable_disable', 'frente');
            TEntry::enableField('form_enable_disable', 'arealote');
            TEntry::enableField('form_enable_disable', 'arealivre');
            TEntry::enableField('form_enable_disable', 'numerounidades');
            TEntry::enableField('form_enable_disable', 'areaconstruida');
            TEntry::enableField('form_enable_disable', 'lateraldireita');
            TEntry::enableField('form_enable_disable', 'lateralesquerda');
            TEntry::enableField('form_enable_disable', 'testadaconstrucao');
            TEntry::enableField('form_enable_disable', 'areatotalconstruida');
            TEntry::enableField('form_enable_disable', 'profundidadeterreno');
            TEntry::enableField('form_enable_disable', 'quantidadepavimentos');
            TEntry::enableField('form_enable_disable', 'profundidadeconstrucao');
            // 10 - Matrícula Cartório
            TText::enableField('form_enable_disable', 'matriculacartorio');   
            
            TButton::enableField('form_enable_disable', 'saveButton'); // Exibe o botão
        }
    }

    public static function onSend($param)
    {
        echo '<pre>';
        var_dump($param);
        echo '</pre>';
    }
    /**
     * onClose
     */
    public function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }

    public function exportAsPDF($param)
{
    try
    {
        // Captura os dados do formulário
        $data = $this->form->getData();

        // Carrega o template HTML
        $template = file_get_contents('app/resources/pdf_template_imobiliario.html');

        // Substitui os placeholders
        $replaces = [
            '{code}'        => $data->code ?? '',
            '{distrito}'         => $data->distrito ?? '',
            '{setor}'            => $data->setor ?? '',
            '{quadra}'           => $data->quadra ?? '',
            '{lote}'             => $data->lote ?? '',
            '{face}'             => $data->face ?? '',
            '{unidade}'          => $data->unidade ?? '',
            '{cep}'              => $data->cep ?? '',
            '{logradouro}'       => $data->logradouro ?? '',
            '{bairro}'           => $data->bairro ?? '',
            '{arealote}'         => $data->arealote ?? '',
            '{areaconstruida}'   => $data->areaconstruida ?? '',
            '{frente}'           => $data->frente ?? '',
            '{data_emissao}'     => date('d/m/Y H:i')
        ];

        $html = str_replace(array_keys($replaces), array_values($replaces), $template);

        // Gera o PDF
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // Salva o PDF
        $output = 'app/output/relatorio_imovel.pdf';
        file_put_contents($output, $dompdf->output());

        // Abre em nova janela
        TPage::openFile($output);
    }
    catch (Exception $e)
    {
        new TMessage('error', $e->getMessage());
    }
}
}
