<?php

class AvaliacaoList extends TPage
{
    private $form;
    private $datagrid;

    public function __construct()
    {
        parent::__construct();
        parent::setTargetContainer('adianti_right_panel');

        // Formulário de busca
        $this->form = new BootstrapFormBuilder('form_avaliacao_api');
        $this->form->setFormTitle('Consultar Avaliações (via API)');

        $inscricao  = new TEntry('inscricao');
        $zoneamento = new TEntry('zoneamento');
        $tipo       = new TCombo('tipo');

        $tipo->addItems([
            'residencial'   => 'Residencial',
            'comercial'     => 'Comercial',
            'industrial'    => 'Industrial',
            'institucional' => 'Institucional'
        ]);

        $this->form->addFields([new TLabel('Inscrição')], [$inscricao]);
        $this->form->addFields([new TLabel('Zoneamento')], [$zoneamento], [new TLabel('Tipo')], [$tipo]);

        $this->form->addAction('Buscar', new TAction([$this, 'onSearch']), 'fa:search blue');
        $this->form->addAction('Fechar', new TAction([$this, 'onClose']), 'fa:times red');

        // Datagrid
        $this->datagrid = new BootstrapDatagridWrapper(new TDataGrid());
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->datatable = 'true';

        $this->datagrid->addColumn(new TDataGridColumn('inscricao', 'Inscrição', 'left'));
        $this->datagrid->addColumn(new TDataGridColumn('zoneamento', 'Zoneamento', 'center'));
        $this->datagrid->addColumn(new TDataGridColumn('area_unida', 'Área (m²)', 'right'));
        $this->datagrid->addColumn(new TDataGridColumn('tipo', 'Tipo', 'center'));
        $this->datagrid->addColumn(new TDataGridColumn('padrao', 'Padrão', 'center'));
        $this->datagrid->addColumn(new TDataGridColumn('valor_estimado', 'Valor Estimado (R$)', 'right'));
        $this->datagrid->addColumn(new TDataGridColumn('bairro', 'Bairro', 'left'));
        $this->datagrid->addColumn(new TDataGridColumn('latitude', 'Lat', 'right', '80'));
        $this->datagrid->addColumn(new TDataGridColumn('longitude', 'Lng', 'right', '80'));

        // Ação "Editar"
        $editAction = new TDataGridAction([$this, 'onEdit'], ['inscricao' => '{inscricao}']);
        $editAction->setLabel('Editar');
        $editAction->setImage('fa:edit green');
        $this->datagrid->addAction($editAction);

        // Ação "Visualizar"
        $viewAction = new TDataGridAction([$this, 'onView'], ['inscricao' => '{inscricao}']);
        $viewAction->setLabel('Ver');
        $viewAction->setImage('fa:eye blue');
        $this->datagrid->addAction($viewAction);

        $this->datagrid->createModel();

        $panel = new TPanelGroup('Resultados da Avaliação');
        $panel->add($this->form);
        $panel->add($this->datagrid);

        parent::add($panel);
    }

    public function onSearch($param)
{
    try {
        $data = $this->form->getData();
        $this->form->setData($data);

        $query = http_build_query([
            'inscricao'  => $data->inscricao,
            'zoneamento' => $data->zoneamento,
            'tipo'       => $data->tipo
        ]);

        $url = "http://127.0.0.1/geojequie.sisprom-br.com.br_11_06_25/vendor/geojequie/buscar_avaliacoes.php?$query";

        $result = file_get_contents($url);
        $json = json_decode($result, true);

        if (!is_array($json) || $json['status'] !== 'success') {
            throw new Exception($json['message'] ?? 'Erro ao consultar API');
        }

        if (empty($json['data'])) {
            new TMessage('info', 'Nenhuma avaliação encontrada.');
            return;
        }

        $this->datagrid->clear();

        foreach ($json['data'] as $item) {
            if (!isset($item['id'])) {
                throw new Exception('O campo "id" está faltando nos dados da API');
            }

            $obj = (object) $item;
            $obj->valor_estimado = number_format($obj->valor_estimado, 2, ',', '.');

            $this->datagrid->addItem($obj);
        }

    } catch (Exception $e) {
        new TMessage('error', 'Erro: ' . $e->getMessage());
    }
}


    public function onView($param)
    {
        try {
        $inscricao = $param['inscricao'] ?? null;

        if (!$inscricao) {
            throw new Exception('Inscrição não recebida');
        }

        // Consulta à API por inscrição
        $url = "http://127.0.0.1/geojequie.sisprom-br.com.br_11_06_25/vendor/geojequie/buscar_avaliacoes.php?inscricao={$inscricao}";
        $result = file_get_contents($url);
        $json = json_decode($result, true);

        if (!is_array($json) || $json['status'] !== 'success' || empty($json['data'][0])) {
            throw new Exception($json['message'] ?? 'Avaliação não encontrada');
        }

        $item = (object) $json['data'][0];

            $params = [
                'class'      => 'calcularValorMercadoForm',
                'inscricao'  => $item->inscricao,
                'zoneamento' => $item->zoneamento,
                'area_unida' => $item->area_unida,
                'tipo'       => $item->tipo,
                'padrao'     => $item->padrao,
                'latitude'   => $item->latitude,
                'longitude'  => $item->longitude,
                'modo'           => 'visualizar',
                'register_state' => 'false'
            ];

            AdiantiCoreApplication::loadPage('calcularValorMercadoForm', 'onLoadFromAvaliacao', $params);

        } catch (Exception $e) {
            TTransaction::rollback();
            new TMessage('error', $e->getMessage());
        }
    }

    public function onEdit($param)
{
    try {
        $inscricao = $param['inscricao'] ?? null;

        if (!$inscricao) {
            throw new Exception('Inscrição não recebida');
        }

        // Consulta à API por inscrição
        $url = "http://127.0.0.1/geojequie.sisprom-br.com.br_11_06_25/vendor/geojequie/buscar_avaliacoes.php?inscricao={$inscricao}";
        $result = file_get_contents($url);
        $json = json_decode($result, true);

        if (!is_array($json) || $json['status'] !== 'success' || empty($json['data'][0])) {
            throw new Exception($json['message'] ?? 'Avaliação não encontrada');
        }

        $item = (object) $json['data'][0];

        $params = [
            'id'         => $item->id, // ✅ necessário
            'inscricao'  => $item->inscricao,
            'zoneamento' => $item->zoneamento,
            'area_unida' => $item->area_unida,
            'tipo'       => $item->tipo,
            'padrao'     => $item->padrao,
            'latitude'   => $item->latitude,
            'longitude'  => $item->longitude,
            'modo'       => 'edicao'
        ];

        TScript::create("__adianti_load_page('index.php?class=calcularValorMercadoForm&" . http_build_query($params) . "', null, 'adianti_right_panel')");

    } catch (Exception $e) {
        new TMessage('error', 'Erro ao abrir para edição: ' . $e->getMessage());
    }
}


 public function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }


}
