<?php

// app/control/TaskForm.php
class TaskForm extends TPage
{
    private $form;

    public function __construct()
{
    parent::__construct();

    // ====> PEGANDO USUÁRIO LOGADO <====
    $userGroupId = TSession::getValue('usergroupids') ?? '0'; 
    $username = TSession::getValue('username') ?? 'Desconhecido'; 

    $userGroupIdString = is_array($userGroupId) ? implode(',', $userGroupId) : $userGroupId;

    error_log('usergroupids: ' . $userGroupIdString);
    error_log('username: ' . $username);

    // ====> FORMULÁRIO <====
    $this->form = new BootstrapFormBuilder('form_task');
    $this->form->setFormTitle('Nova Tarefa');

    // Exibe o usuário logado no topo do formulário
    $usuarioLabel = new TLabel("Usuário conectado: <b>{$username}</b>");
    $this->form->addContent([$usuarioLabel]);

    // Campos da tarefa
    $title        = new TEntry('title');
    $project_id = new TEntry('project_id');
    $status       = new TCombo('status');    
    $description  = new TText('description');
    $start_date   = new TDate('start_date');
    $due_date     = new TDate('due_date');
    $responsible = new TDBCombo('assigned_to', 'permission', 'SystemUser', 'id', 'name');
    $file = new TFile('filename');
    $file->setAllowedExtensions(['gif','png','jpg','jpeg','pdf','doc','docx']);
    $file->setSize('100%');
    $status->addItems([
        'A Fazer'       => 'A Fazer',
        'Em Andamento'  => 'Em Andamento',
        'Concluído'     => 'Concluído'
    ]);

    $start_date->setMask('dd/mm/yyyy');
    $due_date->setMask('dd/mm/yyyy');

    $title->addValidation('Título', new TRequiredValidator);
    $status->addValidation('Status', new TRequiredValidator);
    $responsible->addValidation('Responsável', new TRequiredValidator);
    $start_date->addValidation('Início', new TRequiredValidator);
    $due_date->addValidation('Vencimento', new TRequiredValidator);

    $this->form->addFields([new TLabel('Título*')],       [$title]);
    $this->form->addFields([new TLabel('Projeto')],      [$project_id]);
    $this->form->addFields([new TLabel('Status*')],       [$status]);
    $this->form->addFields([new TLabel('Responsável*')],  [$responsible]);
    $this->form->addFields([new TLabel('Descrição')],    [$description]);
    $this->form->addFields([new TLabel('Início*')],       [$start_date]);
    $this->form->addFields([new TLabel('Vencimento*')],   [$due_date]);
    $this->form->addFields([new TLabel('Arquivo')], [$file]);  

    $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save green');

    parent::add($this->form);
}

   public function onSave($param)
{
    try {
        TTransaction::open('permission');

        $data = $this->form->getData();

        // Converte dd/mm/yyyy para yyyy-mm-dd antes de salvar
        if (!empty($data->start_date)) {
            $data->start_date = TDate::date2us($data->start_date);
        }

        if (!empty($data->due_date)) {
            $data->due_date = TDate::date2us($data->due_date);
        }

        $kanban = new Kanban();
        $kanban->fromArray((array) $data);
        // Define created_by com o id do usuário logado
        $kanban->created_by = TSession::getValue('userid');
        $kanban->created_at = date('Y-m-d H:i:s');
        $kanban->title = $kanban->title ?: 'Sem título';
        $kanban->store();

        // ====> Manipulação do arquivo (se houver)
        $source_file = 'tmp/' . $kanban->filename;
        $target_path = "files/kanban/{$kanban->id}";
        $target_file = "{$target_path}/{$kanban->filename}";

        if (!empty($kanban->filename) && file_exists($source_file)) {
            if (!file_exists($target_path)) {
                if (!@mkdir($target_path, 0777, true)) {
                    throw new Exception("Permissão negada ao criar pasta: $target_path");
                }
            } else {
                foreach (glob("$target_path/*") as $old_file) {
                    unlink($old_file);
                }
            }

            rename($source_file, $target_file);
        }

        // ====> Cria notificação para o responsável
        if (!empty($kanban->assigned_to)) {
            $notification = new SystemNotification();
            $notification->system_user_id    = TSession::getValue('userid');    // quem criou
            $notification->system_user_to_id = $kanban->assigned_to;            // quem recebe
            $notification->subject           = 'Nova tarefa atribuída: ' . $kanban->title;
            $notification->message           = $kanban->description ?: 'Sem descrição';
            $notification->dt_message        = date('Y-m-d H:i:s');
            $notification->action_url        = 'class=KanbanView';
            $notification->icon              = 'fas:tasks blue';
            $notification->checked           = 'N';
            $notification->store();

            error_log('Notificação criada com ID: ' . $notification->id);
        }

        TScript::create('Template.updateNotificationDropdown();');

        TTransaction::close();

        $this->form->setData($kanban);
        new TMessage('info', 'Tarefa criada com sucesso e arquivo salvo (se houver)!');
    } catch (Exception $e) {
        TTransaction::rollback();
        new TMessage('error', 'Erro: ' . $e->getMessage());
    }
}

public function onReload($param = null)
{
    TTransaction::open('permission'); // <- alterado para 'permission'
    
    $criteria = new TCriteria();

    $user_id = TSession::getValue('userid');
    $usergroupids = TSession::getValue('usergroupids') ?? [];

    if (!is_array($usergroupids)) {
        $usergroupids = [$usergroupids];
    }

    if (!in_array(1, $usergroupids)) {
        $criteria->add(new TFilter('assigned_to', '=', $user_id));
    }

    $repo = new TRepository('Kanban');
    $Kanbans = $repo->load($criteria);

    foreach ($Kanbans as $Kanban) {
        error_log('Tarefa: ' . $Kanban->title);
    }

    TTransaction::close();
}

}
