<?php 
/**
 * MapaFiscalizacaoView
 *
 * @version    8.0
 * @package    control
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd.
 * @license    https://adiantiframework.com.br/license-template
 */
class MapaFiscalizacaoView extends TPage
{
    /**
     * Class constructor
     * Creates the page
     */
    function __construct()
    {
        parent::__construct();

        // Obtém o grupo do usuário e o nome do usuário da sessão
        $userGroupId = TSession::getValue('usergroupids') ?? '0';
        $username = TSession::getValue('username') ?? 'Desconhecido'; // Valor padrão caso não exista

        // Se for array, pega o primeiro ou converte conforme necessário
        if (is_array($userGroupId)) {
            // Dependendo de como sua aplicação retorna múltiplos grupos, você pode ajustar esta parte
            // Aqui pegamos o primeiro elemento do array
            $userGroupIdInt = (int) reset($userGroupId);
        } else {
            $userGroupIdInt = (int) $userGroupId;
        }

        // Sanitize username para evitar problemas de aspas / JS
        $usernameJs = addslashes($username);

        // Converter para string para exibir no template, se for usado
        $userGroupIdString = (string) $userGroupIdInt;

        // Logging para debug
        error_log('userGroupIdInt: ' . $userGroupIdInt);
        error_log('username: ' . $username);

        // Cria o renderer HTML
        $this->html = new THtmlRenderer('vendor/geojequie/Mapa_Jequie_Fiscal/mapa_fiscal_jequie.php');

        $ini = AdiantiApplicationConfig::get();

        $replaces = [
            'title'        => _t('Uso e Ocupação do solo'),
            'content'      => $ini['general']['Uso e Ocupação do solo'] ?? '',
            'usergroupid'  => $userGroupIdString,
            'username'     => $username, 
            // Injetar script JS para definir variáveis globais window.userGroupId e window.userName
            'script'       => "<script>
                                  window.userGroupId = " . (int)(is_array($userGroupId) ? reset($userGroupId) : $userGroupId) . ";
                                  window.userName = '{$usernameJs}';
                                  console.log('userGroupId (JS):', window.userGroupId);
                                  console.log('username (JS):', window.userName);
                               </script>"
        ];

        // Substitui variáveis na seção principal do template
        $this->html->enableSection('main', $replaces);

        parent::add($this->html);
    }
}
