<?php
require 'vendor/autoload.php'; // Garante que o Dompdf está carregado

use Dompdf\Dompdf;
use Dompdf\Options;

// **1. Configurar opções do Dompdf**
$options = new Options();
$options->set('defaultFont', 'Arial'); 
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);

// **2. Criar o conteúdo do PDF**
$html = '
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; font-size: 12pt; }
        h1 { text-align: center; font-size: 18pt; color: #333; }
        ul { margin: 20px; padding: 0; }
        li { font-size: 12pt; margin: 8px 0; }
        .container { width: 90%; margin: auto; text-align: left; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Checklist de Documentos</h1>
        <ul>
            <li>Xerox da Escritura pública registrada em cartório</li>
            <li>Xerox da Certidão de inteiro teor atualizada</li>
            <li>Xerox do RG e CPF (Se for empresa CNPJ + Contrato social)</li>
            <li>Ficha de conformidade (IPTU)</li>
            <li>02 vias das Plantas de localização e situação</li>
            <li>ART do profissional assinada pelo engenheiro e proprietário</li>
        </ul>
    </div>
</body>
</html>';

// **3. Carregar o HTML no Dompdf**
$dompdf->loadHtml($html);

// **4. Definir tamanho do papel e orientação**
$dompdf->setPaper('A4', 'portrait');

// **5. Renderizar o PDF**
$dompdf->render();

// **6. Limpar qualquer saída antes de gerar o PDF**
ob_end_clean();

// **7. Enviar o PDF para o navegador**
$dompdf->stream('checklist.pdf', ['Attachment' => false]); // Exibir no navegador
exit;
?>
