<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Widget\Container\TPanelGroup;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TEntry;
use Adianti\Database\TRepository;
use Adianti\Database\TCriteria;
use Adianti\Database\TFilter;
use Adianti\Widget\Wrapper\TQuickForm;
use Adianti\Widget\Datagrid\TDataGridColumn;
use Adianti\Widget\Datagrid\TDataGridAction;
use Adianti\Widget\Datagrid\TDataGrid;
use Adianti\Widget\Dialog\TQuestion;

use Adianti\Database\TTransaction;

// Compat: alias para TSession em diferentes versões
if (!class_exists('TSession')) {
    if (class_exists('\Adianti\Core\TSession')) {
        class_alias('\Adianti\Core\TSession', 'TSession');
    } elseif (class_exists('\Adianti\Registry\TSession')) {
        class_alias('\Adianti\Registry\TSession', 'TSession');
    }
}

class PessoasList extends TPage
{
    private $form;
    private $datagrid;
    private $loaded;

    public function __construct()
    {
        parent::__construct();

        $this->form = new TQuickForm('form_search_Pessoas');
        $this->form->setFormTitle('Pessoas - Busca');

        $id        = new TEntry('id');
        $nome      = new TEntry('nome');
        $documento = new TEntry('documento');

        $this->form->addQuickField('ID',        $id,        100);
        $this->form->addQuickField('Nome',      $nome,      300);
        $this->form->addQuickField('Documento', $documento, 200);

        $this->form->setData( TSession::getValue('search_Pessoas') );

        $this->form->addQuickAction('Buscar', new TAction([$this, 'onSearch']), 'fa:search');
        $this->form->addQuickAction('Novo',   new TAction(['PessoasForm', 'onClear']), 'fa:plus green');

        $this->datagrid = new TDataGrid;
        $this->datagrid->style     = 'width: 100%';
        $this->datagrid->datatable = 'true';

        $col_id        = new TDataGridColumn('id', 'ID', 'center', '5%');
        $col_nome      = new TDataGridColumn('nome', 'Nome', 'left', '25%');
        $col_natureza  = new TDataGridColumn('natureza_fisica_juridica', 'Natureza', 'center', '10%');
        $col_documento = new TDataGridColumn('documento', 'Documento', 'center', '12%');
        $col_email     = new TDataGridColumn('email', 'Email', 'left', '18%');
        $col_celular   = new TDataGridColumn('celular', 'Celular', 'center', '10%');
        $col_municipio = new TDataGridColumn('municipio_nome', 'Município/Localidade', 'left', '10%');
        $col_bairro    = new TDataGridColumn('bairro_nome', 'Bairro', 'left', '10%');
        $col_logra     = new TDataGridColumn('logradouro_nome', 'Logradouro', 'left', '10%');

        $this->datagrid->addColumn($col_id);
        $this->datagrid->addColumn($col_nome);
        $this->datagrid->addColumn($col_natureza);
        $this->datagrid->addColumn($col_documento);
        $this->datagrid->addColumn($col_email);
        $this->datagrid->addColumn($col_celular);
        $this->datagrid->addColumn($col_municipio);
        $this->datagrid->addColumn($col_bairro);
        $this->datagrid->addColumn($col_logra);

        $action_edit = new TDataGridAction(['PessoasForm', 'onEdit']);
        $action_edit->setLabel('Editar');
        $action_edit->setImage('fa:edit blue');
        $action_edit->setField('id');

        $action_del  = new TDataGridAction([$this, 'onDelete']);
        $action_del->setLabel('Excluir');
        $action_del->setImage('fa:trash red');
        $action_del->setField('id');

        $this->datagrid->addAction($action_edit);
        $this->datagrid->addAction($action_del);

        $this->datagrid->createModel();

        $panel = new TPanelGroup('Pessoas - Lista');
        $panel->add($this->form);
        $panel->add($this->datagrid);

        parent::add($panel);
    }

    public function onSearch($param)
    {
        $data = $this->form->getData();
        TSession::setValue('search_Pessoas', $data);
        $this->onReload($param);
    }

    public function onReload($param = null)
    {
        try {
            TTransaction::open('comum');

            $repo     = new TRepository('Pessoas');
            $criteria = new TCriteria;

            $data = TSession::getValue('search_Pessoas');

            if ($data) {
                if (!empty($data->id))        { $criteria->add(new TFilter('id', '=', $data->id)); }
                if (!empty($data->nome))      { $criteria->add(new TFilter('nome', 'ilike', "%{$data->nome}%")); }
                if (!empty($data->documento)) { $criteria->add(new TFilter('documento', 'ilike', "%{$data->documento}%")); }
            }

            $objects = $repo->load($criteria);

            // Preload nomes (Município, Bairro, Logradouro)
            $munMap   = [];
            $bairroMap= [];
            $lograMap = [];
            if ($objects) {
                $idsMun   = [];
                $idsBairro= [];
                $idsLogra = [];
                foreach ($objects as $o) {
                    if (!empty($o->id_munic_local)) { $idsMun[]    = (int)$o->id_munic_local; }
                    if (!empty($o->id_bairro))      { $idsBairro[] = (int)$o->id_bairro; }
                    if (!empty($o->id_logradouro))  { $idsLogra[]  = (int)$o->id_logradouro; }
                }
                if ($idsMun) {
                    $idsMun = array_values(array_unique($idsMun));
                    $r = new TRepository('MunicipioLocalidade');
                    $c = new TCriteria; $c->add(new TFilter('id', 'in', $idsMun));
                    foreach ((array)$r->load($c) as $m) { $munMap[(int)$m->id] = $m->nome; }
                }
                if ($idsBairro) {
                    $idsBairro = array_values(array_unique($idsBairro));
                    $r = new TRepository('Bairro');
                    $c = new TCriteria; $c->add(new TFilter('id', 'in', $idsBairro));
                    foreach ((array)$r->load($c) as $b) { $bairroMap[(int)$b->id] = $b->nome; }
                }
                if ($idsLogra) {
                    $idsLogra = array_values(array_unique($idsLogra));
                    $r = new TRepository('Logradouro');
                    $c = new TCriteria; $c->add(new TFilter('id', 'in', $idsLogra));
                    foreach ((array)$r->load($c) as $l) { $lograMap[(int)$l->id] = $l->nome; }
                }
            }

            $this->datagrid->clear();
            if ($objects) {
                foreach ($objects as $obj) {
                    $obj->municipio_nome  = $munMap[(int)$obj->id_munic_local] ?? '';
                    $obj->bairro_nome     = $bairroMap[(int)$obj->id_bairro] ?? '';
                    $obj->logradouro_nome = $lograMap[(int)$obj->id_logradouro] ?? '';
                    $this->datagrid->addItem($obj);
                }
            }

            TTransaction::close();
            $this->loaded = true;
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onDelete($param)
    {
        $action = new TAction([$this, 'Delete']);
        $action->setParameters($param);
        new TQuestion('Confirma excluir?', $action);
    }

    public function Delete($param)
    {
        try {
            TTransaction::open('comum');
            $object = new Pessoas($param['id']);
            $object->delete();
            TTransaction::close();
            $this->onReload();
            new TMessage('info', 'Registro excluído');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function show()
    {
        if (!$this->loaded) {
            $this->onReload(func_get_arg(0));
        }
        parent::show();
    }
}
