<?php
use Adianti\Control\TPage;
use Adianti\Control\TAction;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TCombo;
use Adianti\Widget\Wrapper\TDBCombo;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Container\TPanelGroup;

class PessoasForm extends TPage
{
    private $form;

    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_Pessoas');
        $this->form->setFormTitle('Pessoas');
        $this->form->setFieldSizes('100%');

        $id=new TEntry('id');$id->setEditable(FALSE);$nome=new TEntry('nome');$natureza=new TCombo('natureza_fisica_juridica');$natureza->addItems(['FISICA'=>'Física','JURIDICA'=>'Jurídica','ESTRANGEIRO'=>'Estrangeiro']);$documento=new TEntry('documento');$email=new TEntry('email');$celular=new TEntry('celular');$whatsapp=new TEntry('whatsapp');$cep=new TEntry('cep_logradouro');$id_munic_local=new TDBCombo('id_munic_local','comum','MunicipioLocalidade','id','nome');$id_bairro=new TDBCombo('id_bairro','comum','Bairro','id','nome');$id_logradouro=new TDBCombo('id_logradouro','comum','Logradouro','id','nome');$numero=new TEntry('numero_endereco');$compl=new TEntry('complemento_endereco');$this->form->addFields([new TLabel('ID'),$id],[new TLabel('Nome'),$nome]);$this->form->addFields([new TLabel('Natureza'),$natureza],[new TLabel('Documento'),$documento]);$this->form->addFields([new TLabel('Email'),$email],[new TLabel('Celular'),$celular],[new TLabel('WhatsApp'),$whatsapp]);$this->form->addFields([new TLabel('CEP'),$cep],[new TLabel('Município/Localidade'),$id_munic_local]);$this->form->addFields([new TLabel('Bairro'),$id_bairro],[new TLabel('Logradouro'),$id_logradouro]);$this->form->addFields([new TLabel('Número'),$numero],[new TLabel('Compl.'),$compl]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        $this->form->addAction('Voltar', new TAction(['PessoasList', 'onReload']), 'fa:arrow-left');

        $panel = new TPanelGroup('Pessoas');
        $panel->add($this->form);
        parent::add($panel);
    }

    public function onSave($param)
    {
        try {
            TTransaction::open('comum');

            $object = new Pessoas;
            $data = $this->form->getData();

            $object->fromArray((array) $data);
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Registro salvo com sucesso');
            TApplication::gotoPage('PessoasList');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onEdit($param)
    {
        try {
            TTransaction::open('comum');
            if (isset($param['id'])) {
                $object = new Pessoas($param['id']);
                $this->form->setData($object->toArray());
            } else {
                $this->form->clear();
            }
            TTransaction::close();
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onClear($param = null)
    {
        $this->form->clear(TRUE);
    }
}
