<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Widget\Container\TPanelGroup;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TEntry;
use Adianti\Database\TRepository;
use Adianti\Database\TCriteria;
use Adianti\Database\TFilter;
use Adianti\Widget\Wrapper\TQuickForm;
use Adianti\Widget\Datagrid\TDataGridColumn;
use Adianti\Widget\Datagrid\TDataGridAction;
use Adianti\Widget\Datagrid\TDataGrid;
use Adianti\Widget\Dialog\TQuestion;

class GestorList extends TPage
{
    private $form;
    private $datagrid;
    private $loaded;

    public function __construct()
    {
        parent::__construct();

        $this->form = new TQuickForm('form_search_Gestor');
        $this->form->setFormTitle('Gestor - Busca');

        $id = new TEntry('id');
        $this->form->addQuickField('ID', $id, 100);

        

        $this->form->setData( TSession::get('search_Gestor') );

        $this->form->addQuickAction('Buscar', new TAction([$this, 'onSearch']), 'fa:search');
        $this->form->addQuickAction('Novo', new TAction(['GestorForm', 'onClear']), 'fa:plus green');

        $this->datagrid = new TDataGrid;
        $this->datagrid->style = 'width: 100%';
        $this->datagrid->datatable = 'true';

        $col_id = new TDataGridColumn('id', 'ID', 'center', '10%');\n        $col_id_pessoas = new TDataGridColumn('id_pessoas', 'Pessoa', 'left', '40%');\n        $col_brasao = new TDataGridColumn('brasao', 'Brasão (path/url)', 'left', '30%');\n        $col_complemento = new TDataGridColumn('complemento', 'Compl.', 'left', '20%');\n        $this->datagrid->addColumn($col_id);\n        $this->datagrid->addColumn($col_id_pessoas);\n        $this->datagrid->addColumn($col_brasao);\n        $this->datagrid->addColumn($col_complemento);

        $action_edit = new TDataGridAction(['GestorForm', 'onEdit'], ['id' => 'id']);
        $action_del  = new TDataGridAction([$this, 'onDelete'], ['id' => 'id']);
        $action_del->setLabel('Excluir');
        $action_del->setImage('fa:trash red');
        $action_edit->setLabel('Editar');
        $action_edit->setImage('fa:edit blue');

        $this->datagrid->addAction($action_edit);
        $this->datagrid->addAction($action_del);

        $this->datagrid->createModel();

        $panel = new TPanelGroup('Gestor - Lista');
        $panel->add($this->form);
        $panel->add($this->datagrid);

        parent::add($panel);
    }

    public function onSearch($param)
    {
        $data = $this->form->getData();
        TSession::set('search_Gestor', $data);
        $this->onReload( $param );
    }

    public function onReload($param = null)
    {
        try {
            TTransaction::open('comum');

            $repository = new TRepository('Gestor');
            $criteria = new TCriteria;

            $data = TSession::get('search_Gestor');

            if ($data) \n            if (!empty($data->id)) $criteria->add(new TFilter('id','=','{$data->id}'));

            $objects = $repository->load($criteria);

            $this->datagrid->clear();
            if ($objects) {
                foreach ($objects as $object) {
                    $this->datagrid->addItem($object);
                }
            }
            TTransaction::close();
            $this->loaded = true;
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onDelete($param)
    {
        $action = new TAction([$this, 'Delete']);
        $action->setParameters($param);
        new TQuestion('Confirma excluir?', $action);
    }

    public function Delete($param)
    {
        try {
            TTransaction::open('comum');
            $object = new Gestor($param['id']);
            $object->delete();
            TTransaction::close();
            $this->onReload();
            new TMessage('info', 'Registro excluído');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function show()
    {
        if (!$this->loaded) {
            $this->onReload(func_get_arg(0));
        }
        parent::show();
    }
}
