<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Widget\Container\TPanelGroup;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TEntry;
use Adianti\Database\TRepository;
use Adianti\Database\TCriteria;
use Adianti\Database\TFilter;
use Adianti\Widget\Wrapper\TQuickForm;
use Adianti\Widget\Datagrid\TDataGridColumn;
use Adianti\Widget\Datagrid\TDataGridAction;
use Adianti\Widget\Datagrid\TDataGrid;
use Adianti\Widget\Dialog\TQuestion;

use Adianti\Database\TTransaction;

// Compat: alias para TSession em diferentes versões
if (!class_exists('TSession')) {
    if (class_exists('\Adianti\Core\TSession')) {
        class_alias('\Adianti\Core\TSession', 'TSession');
    } elseif (class_exists('\Adianti\Registry\TSession')) {
        class_alias('\Adianti\Registry\TSession', 'TSession');
    }
}

class EstadoList extends TPage
{
    private $form;
    private $datagrid;
    private $loaded;

    public function __construct()
    {
        parent::__construct();

        $this->form = new TQuickForm('form_search_Estado');
        $this->form->setFormTitle('Estado - Busca');

        $id   = new TEntry('id');
        $nome = new TEntry('nome');

        $this->form->addQuickField('ID',   $id,   100);
        $this->form->addQuickField('Nome', $nome, 300);

        $this->form->setData( TSession::getValue('search_Estado') );

        $this->form->addQuickAction('Buscar', new TAction([$this, 'onSearch']), 'fa:search');
        $this->form->addQuickAction('Novo',   new TAction(['EstadoForm', 'onClear']), 'fa:plus green');

        $this->datagrid = new TDataGrid;
        $this->datagrid->style     = 'width: 100%';
        $this->datagrid->datatable = 'true';

        $col_id        = new TDataGridColumn('id', 'ID', 'center', '8%');
        $col_pais_nome = new TDataGridColumn('pais_nome', 'País', 'left', '22%');
        $col_nome      = new TDataGridColumn('nome', 'Nome', 'left', '40%');
        $col_sigla     = new TDataGridColumn('sigla', 'UF', 'center', '10%');
        $col_ibge      = new TDataGridColumn('codigo_ibge', 'IBGE', 'center', '20%');

        $this->datagrid->addColumn($col_id);
        $this->datagrid->addColumn($col_pais_nome);
        $this->datagrid->addColumn($col_nome);
        $this->datagrid->addColumn($col_sigla);
        $this->datagrid->addColumn($col_ibge);

        $action_edit = new TDataGridAction(['EstadoForm', 'onEdit']);
        $action_edit->setLabel('Editar');
        $action_edit->setImage('fa:edit blue');
        $action_edit->setField('id');

        $action_del  = new TDataGridAction([$this, 'onDelete']);
        $action_del->setLabel('Excluir');
        $action_del->setImage('fa:trash red');
        $action_del->setField('id');

        $this->datagrid->addAction($action_edit);
        $this->datagrid->addAction($action_del);

        $this->datagrid->createModel();

        $panel = new TPanelGroup('Estado - Lista');
        $panel->add($this->form);
        $panel->add($this->datagrid);

        parent::add($panel);
    }

    public function onSearch($param)
    {
        $data = $this->form->getData();
        TSession::setValue('search_Estado', $data);
        $this->onReload($param);
    }

    public function onReload($param = null)
    {
        try {
            TTransaction::open('comum');

            $repo     = new TRepository('Estado');
            $criteria = new TCriteria;

            $data = TSession::getValue('search_Estado');

            if ($data) {
                if (!empty($data->id))   { $criteria->add(new TFilter('id', '=', $data->id)); }
                if (!empty($data->nome)) { $criteria->add(new TFilter('nome', 'ilike', "%{$data->nome}%")); }
            }

            $objects = $repo->load($criteria);

            // Preload nomes dos países
            $paisMap = [];
            if ($objects) {
                $ids = [];
                foreach ($objects as $o) {
                    if (!empty($o->id_pais)) { $ids[] = (int)$o->id_pais; }
                }
                if ($ids) {
                    $ids = array_values(array_unique($ids));
                    $repoPais = new TRepository('Pais');
                    $critPais = new TCriteria;
                    $critPais->add(new TFilter('id', 'in', $ids));
                    $paises = $repoPais->load($critPais);
                    if ($paises) {
                        foreach ($paises as $p) {
                            $paisMap[(int)$p->id] = $p->nome;
                        }
                    }
                }
            }

            $this->datagrid->clear();
            if ($objects) {
                foreach ($objects as $obj) {
                    $obj->pais_nome = $paisMap[(int)$obj->id_pais] ?? '';
                    $this->datagrid->addItem($obj);
                }
            }

            TTransaction::close();
            $this->loaded = true;
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onDelete($param)
    {
        $action = new TAction([$this, 'Delete']);
        $action->setParameters($param);
        new TQuestion('Confirma excluir?', $action);
    }

    public function Delete($param)
    {
        try {
            TTransaction::open('comum');
            $object = new Estado($param['id']);
            $object->delete();
            TTransaction::close();
            $this->onReload();
            new TMessage('info', 'Registro excluído');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function show()
    {
        if (!$this->loaded) {
            $this->onReload(func_get_arg(0));
        }
        parent::show();
    }
}
