<?php
use Adianti\Control\TPage;
use Adianti\Control\TAction;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TCombo;
use Adianti\Widget\Wrapper\TDBCombo;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Container\TPanelGroup;

class BairroForm extends TPage
{
    private $form;

    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_Bairro');
        $this->form->setFormTitle('Bairro');
        $this->form->setFieldSizes('100%');

        $id=new TEntry('id');$id->setEditable(FALSE);$id_munic_local=new TDBCombo('id_munic_local','comum','MunicipioLocalidade','id','nome');$nome=new TEntry('nome');$this->form->addFields([new TLabel('ID'),$id],[new TLabel('Município/Localidade'),$id_munic_local]);$this->form->addFields([new TLabel('Nome'),$nome]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        $this->form->addAction('Voltar', new TAction(['BairroList', 'onReload']), 'fa:arrow-left');

        $panel = new TPanelGroup('Bairro');
        $panel->add($this->form);
        parent::add($panel);
    }

    public function onSave($param)
    {
        try {
            TTransaction::open('comum');

            $object = new Bairro;
            $data = $this->form->getData();

            $object->fromArray((array) $data);
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Registro salvo com sucesso');
            TApplication::gotoPage('BairroList');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onEdit($param)
    {
        try {
            TTransaction::open('comum');
            if (isset($param['id'])) {
                $object = new Bairro($param['id']);
                $this->form->setData($object->toArray());
            } else {
                $this->form->clear();
            }
            TTransaction::close();
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onClear($param = null)
    {
        $this->form->clear(TRUE);
    }
}
