<?php
/**
 * CommonPage
 *
 * @version    8.0
 * @package    control
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class CommonPage extends TPage
{
    public function __construct()
    {
        parent::__construct();
        
        $panel = new TPanelGroup('Protocolo de Alvará');
        
        $tipoAlvara = new TCombo('tipoAlvara');
        $tipoAlvara->addItems(['construcao' => 'Construção', 'reforma' => 'Reforma', 'demolicao' => 'Demolição']);
        $tipoAlvara->setChangeAction(new TAction([$this, 'onChangeTipoAlvara']));
        
        $areaConstruida = new TEntry('areaConstruida');
        $nroPavimentos = new TEntry('nroPavimentos');
        $descricaoReforma = new TText('descricaoReforma');
        $justificativaDemolicao = new TText('justificativaDemolicao');
        
        $form = new TQuickForm('form_protocolo');
        $form->addQuickField('Tipo de Alvará', $tipoAlvara);
        
        $form->addQuickField('Área Construída (m²)', $areaConstruida)->style = 'display:none';
        $form->addQuickField('Número de Pavimentos', $nroPavimentos)->style = 'display:none';
        $form->addQuickField('Descrição da Reforma', $descricaoReforma)->style = 'display:none';
        $form->addQuickField('Justificativa para Demolição', $justificativaDemolicao)->style = 'display:none';
        
        $form->addQuickAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        
        $panel->add($form);
        parent::add($panel);
    }
    
    public static function onChangeTipoAlvara($param)
    {
        TScript::create("document.getElementsByName('areaConstruida')[0].parentNode.style.display = 'none';");
        TScript::create("document.getElementsByName('nroPavimentos')[0].parentNode.style.display = 'none';");
        TScript::create("document.getElementsByName('descricaoReforma')[0].parentNode.style.display = 'none';
");
        TScript::create("document.getElementsByName('justificativaDemolicao')[0].parentNode.style.display = 'none';");
        
        if ($param['tipoAlvara'] == 'construcao') {
            TScript::create("document.getElementsByName('areaConstruida')[0].parentNode.style.display = 'block';");
            TScript::create("document.getElementsByName('nroPavimentos')[0].parentNode.style.display = 'block';");
        } elseif ($param['tipoAlvara'] == 'reforma') {
            TScript::create("document.getElementsByName('descricaoReforma')[0].parentNode.style.display = 'block';");
        } elseif ($param['tipoAlvara'] == 'demolicao') {
            TScript::create("document.getElementsByName('justificativaDemolicao')[0].parentNode.style.display = 'block';");
        }
    }
    
    public function onSave($param)
    {
        new TMessage('info', 'Protocolo salvo com sucesso!');
    }
}
